package com.js.web.controller.loan;

import com.js.common.constant.Constant;
import com.js.common.model.req.KycLoanBankReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsKycLoanBankService;
import com.js.web.service.JsKycNaturalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.Optional;

/**
 * @Author zhouyngsheng
 * @Description 接口端银行卡绑卡controller
 * @Date 2019/8/1
 **/
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class LoanBankController {

    @Autowired
    JsKycNaturalService jsKycNaturalService;
    @Autowired
    JsKycLoanBankService jsKycLoanBankService;

    /**
     * 绑卡贷款银行卡
     * @return
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/loanBank/add",consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage addBank(@Valid @RequestBody KycLoanBankReq kycLoanBankReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsKycLoanBankService.addBank(kycLoanBankReq,response,optionalKycNaturalVO.get());
    }

    /**
     * 用户下用户卡查询
     * @return
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/loanBank/query")
    public ResponseMessage queryBankList(HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsKycLoanBankService.queryBankList(optionalKycNaturalVO.get().getId());
    }

}
