package com.js.web.utils;

import com.js.common.constant.Constant;
import com.js.web.controller.web.JsFileController;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * oss 文件辅助工具类
 *
 * @see JsFileController
 */
@Component
public class OSSUtil {

    static String vhost;

    @Value("${aliyun.oss.js.web.vhost}")
    public void setVhost( String vhost) {
        OSSUtil.vhost = vhost;
    }

    /**
     * 根据文件路径生成下载可以使用的 http 链接。
     * @param fileUrl
     * @param fileName
     * @return
     */
    public static String generateDownloadUrl(String fileUrl, String fileName) {
        String url = vhost + Constant.ApiPath.V1 + Constant.ApiLoginAuth.ANON +"/jsFile/downLoad?filePath=" +
                fileUrl + "&fileName=" + fileName;
        return url;
    }

    /**
     * 根据文件路径生成预览可以使用的 http 链接。
     * @param fileUrl
     * @param fileName
     * @return
     */
    public static String generatePreviewUrl(String fileUrl, String fileName, String contentType) {
        String url = vhost + Constant.ApiPath.V1 + Constant.ApiLoginAuth.ANON +"/jsFile/preview?filePath=" +
                fileUrl + "&fileName=" + fileName + "&contentType=" + contentType;
        return url;
    }
}
