package com.js.web.utils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.js.common.enums.CurrEnum;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.formula.functions.T;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;

import com.alibaba.fastjson.JSON;

import cn.hutool.core.io.FileUtil;
import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;

/**
 * excel业务封装
 * @author lwm
 */

public class ExcelBizUtil<T> {

    public static void main(String[] args) {
//        ExcelBizUtil.readExcel("",0,"");
    }
    public static ExcelReader getFlag(String path ,int index,String flag) {
        //模板处理 sheetIndex=0代表第一个
        ExcelReader readerModel = ExcelUtil.getReader(FileUtil.file(path),index);
        String fileFlag = getValue(readerModel.getCell(0,0));
        CurrEnum[] currEnums = CurrEnum.values();
        for(CurrEnum curr : currEnums){
            if(curr.getEnumCode().equals(flag) && curr.toString().equals(fileFlag)){
                return readerModel;
            }
        }
        return null;
    }


    public List<T> readExcel(ExcelReader readerModel, T VOStrs) {
        //模板处理 sheetIndex=0代表第一个
//        ExcelReader readerModel = ExcelUtil.getReader(FileUtil.file(path),index);
        List<T> list=new ArrayList<T>();
        int rowCount = readerModel.getRowCount();
        String [] strs = VOStrs.toString().split("|");
        int cellLength = strs.length;
        for(int row =3;row<=rowCount;row++){
            Map<String,String> excelMap = new LinkedHashMap<String,String>();
            addCellToMapPlus(readerModel, excelMap, strs, row , cellLength);
            String json = JSON.toJSONString(excelMap);
            T t = (T)JSON.parseObject(json,VOStrs.getClass());
            list.add(t);
        }
        return list;
    }

     /**
      *  将excel一行数据添加到map(key,value)
     * @author lwm
     */
    public static void addCellToMapPlus(ExcelReader reader,Map<String,String> map,String[] strs,int row_start,int cell) {
        for(int r = 0;r <= cell;r++) {
            addCellToMap(reader, map, row_start, cell,strs[r]);
        }
    }

    /**
     * 将excel数据添加到map(key,value)
     * @author lwm
     */
    public static void addCellToMap(ExcelReader reader,Map<String,String> map,int row,int cell,String str) {
        map.put(str, getValue(reader.getSheet().getRow(row).getCell(cell)));
    }
    /**
     * 获取excel的值
     * @author lwm
     */
    public static String getValue(Cell c) {
        try {
            if(CellType.NUMERIC.equals(c.getCellTypeEnum())) {
                return c.getNumericCellValue()+"";
            }else{
                return c.getStringCellValue()+"";
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }
}
