package com.js.web.service.impl;

import com.js.api.jspay.service.ApiKycDictionaryService;
import com.js.common.constant.Constant;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsKycDictionaryService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.stereotype.Service;

/**
 * @ClassName: JsKycDictionaryServiceImpl
 * @Description: 字典服务实现
 * @Author: liuh
 * @Create: 2019-05-18
 **/
@Slf4j
@Service
public class JsKycDictionaryServiceImpl implements JsKycDictionaryService {

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    private ApiKycDictionaryService apiKycDictionaryService;

    @Override
    public ResponseMessage findDictionary(String type,String code) {
        return apiKycDictionaryService.findDictionary(type,code);
    }

}
