package com.js.web.service.impl;

import com.alibaba.fastjson.JSON;
import com.js.api.jspay.service.*;
import com.js.common.constant.Constant;
import com.js.common.enums.CertiStatusEnum;
import com.js.common.enums.EmailRemindTypeEnum;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.*;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.web.mq.RabbitMQSender;
import com.js.web.service.IMailService;
import com.js.web.service.JsKycCertiHKPersonalService;
import com.js.web.service.JsKycSunrateBeneficiaryService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @Description: 香港个人操作服务实现
 * @Author: liuh
 * @Create: 2019-05-31
 **/
@Slf4j
@Service
public class JsKycCertiHKPersonalServiceImpl implements JsKycCertiHKPersonalService {
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiKycCertiHKPersonalService apiKycCertiHKPersonalService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiKycSunrateService apiKycSunrateService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiSunrateRegisterService apiSunrateRegisterService;
    @Autowired
    JsKycSunrateBeneficiaryService jsKycSunrateBeneficiaryService;
    @Autowired
    RabbitMQSender rabbitMQSender;
    @Autowired
    IMailService iMailService;

    @Override
    public ResponseMessage certiHKPersonalAdd(KycCertiHKPersonalReq kycCertiHKPersonalReq, KycNaturalVO kycNaturalVO) {
        log.info("香港个人实名入参：{}", kycCertiHKPersonalReq);
        if(!CertiStatusEnum.NO_SUBMIT.equals(kycNaturalVO.getCertificationStatus()) && !CertiStatusEnum.FIRST_TRIAL_FAILURE.equals(kycNaturalVO.getCertificationStatus())){
            log.error("{},{}用户已提交实名信息:{}",kycNaturalVO.getId(),kycNaturalVO.getRegisterType(),kycNaturalVO.getCertificationStatus());
            return ResultUtil.error(ResultEnum.CERTI_ALREADY_SUBMIT);
        }
        if(StringUtils.isNotBlank(kycCertiHKPersonalReq.getId()) && kycNaturalVO.getId().equals(kycCertiHKPersonalReq.getId())){
            log.error("当前登录用户：{}，需要编辑用户：{}，不符合",kycNaturalVO.getId(),kycCertiHKPersonalReq.getId());
            return ResultUtil.error(ResultEnum.ERROR);
        }
        if(!kycNaturalVO.getEmailActiveFlag()){
            log.error("邮箱未激活,不可以提交实名信息");
            return ResultUtil.error(ResultEnum.EMAIL_NOT_ACTIVE);
        }
        if(StringUtils.isBlank(kycCertiHKPersonalReq.getId())) {
            boolean existsFlag = apiKycCertiHKPersonalService.verifyCertiHKPersonalExists(kycCertiHKPersonalReq.getCertificateNo());
            if (existsFlag) {
                return ResultUtil.error(ResultEnum.MESSAGE_EXIST.getCode(), ResultEnum.MESSAGE_EXIST.getMsg());
            }
        }
        try {
            ResponseMessage operPersonResponseMessage = null;
            if(StringUtils.isBlank(kycCertiHKPersonalReq.getId())){
                log.info("保存香港个人-实名信息-开始");
                operPersonResponseMessage = apiKycCertiHKPersonalService.certiHKPersonalAdd(kycCertiHKPersonalReq, kycNaturalVO);
                log.info("保存香港个人-实名信息-结束返回结果:{},描述信息:{}", operPersonResponseMessage.isSuccess(), operPersonResponseMessage.getMsg());
            }else{
                log.info("编辑香港个人-实名信息-开始");
                operPersonResponseMessage = apiKycCertiHKPersonalService.certiHKPersonalUpdate(kycCertiHKPersonalReq, kycNaturalVO);
                log.info("编辑香港个人-实名信息-结束返回结果:{},描述信息:{}", operPersonResponseMessage.isSuccess(), operPersonResponseMessage.getMsg());
            }
            if(operPersonResponseMessage.isSuccess()){
                String phoneNo = kycNaturalVO.getPhoneNo();
                String phoneStr = phoneNo.substring(3,7);
                String str = phoneNo.replace(phoneStr,"****");
                String emailContent = "亲，有新用户注册啦，请尽快审核。用户名：" + kycCertiHKPersonalReq.getCusName() + ",手机号：" + str;
                iMailService.sendRemindEmail("用户审核提醒",emailContent , EmailRemindTypeEnum.REMIND_EMAIL);
            }
            return operPersonResponseMessage;
        }catch (Exception ex){
            log.error("香港个人实名认证处理异常", ex);
            iMailService.sendRemindEmail("香港个人实名认证处理异常", "香港个人实名认证处理异常:" + JSON.toJSONString(ex), EmailRemindTypeEnum.WARN_EMAIL);
            return ResultUtil.error(ResultEnum.ERROR);
        }
    }
}
