package com.js.web.service.impl;

import cn.hutool.core.util.IdUtil;
import com.aliyun.oss.OSSClient;
import com.js.api.jspay.service.ApiJsCommFileResourceService;
import com.js.common.constant.Constant;
import com.js.common.enums.*;
import com.js.common.model.req.JsCommFileResourceReq;
import com.js.common.model.vo.FileVo;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.FileMngForOSSUtil;
import com.js.common.util.ResultUtil;
import com.js.web.properties.JswebOSSPropertie;
import com.js.web.service.JsFileSerivce;
import com.js.web.utils.TAipUtil;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.io.InputStream;

/**
 * @Author yjzhao
 * @Description 文件服务实现类
 * @Date 2019/5/17 16:50
 * @Param
 * @return
 **/
@Service("fileForOSSService")
public class JsFileForOSSServiceImpl implements JsFileSerivce {

    @Autowired
    JswebOSSPropertie jswebOSSPropertie;

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    ApiJsCommFileResourceService apiJsCommFileResourceService;

    @Autowired
    OSSClient oSSClient;

    @Override
    public ResponseMessage uploadFile(MultipartFile file, FileType fileType, FileResourceType fileResourceType, CertiFileType certiFileType) {

        String baseFileKey = jswebOSSPropertie.getBaseFileKey();
        FileMngForOSSUtil fileUploadForOSSUtil = new FileMngForOSSUtil(jswebOSSPropertie.getBucket(), baseFileKey, oSSClient);

        FileVo fileVo = fileUploadForOSSUtil.fileUpload(file, fileType, fileResourceType);
        //保存数据
        fileVo.setId(IdUtil.simpleUUID());
        apiJsCommFileResourceService.saveJsCommFileResource(convertToJsCommFileResourceReq(fileVo));
        //当时上传图片来源为提交实名认证，且文件类型为图片，且不等于其他类型时，进入OCR识别方法
        if(FileResourceType.REAL_NAME_CERTIFICATE.equals(fileResourceType) && FileType.IMAGE.equals(fileType) && !CertiFileType.OTHER.equals(certiFileType)){
            ResponseMessage ocr = TAipUtil.ocrIdentify(file, certiFileType);
            if(ocr.isSuccess()){
                fileVo.setOcrData(ocr.getData());
            }
        }
        return ResultUtil.success(fileVo, ResultEnum.FILE_UPLOAD_SUCCESS.getCode(), ResultEnum.FILE_UPLOAD_SUCCESS.getMsg());
    }

    /**
     * @Author yjzhao
     * @Description 根据OSS 文件存储路径删除文件
     * @Date 2019/5/18 20:28
     * @Param [fileUrl]
     * @return com.js.common.model.vo.common.ResponseMessage
     **/
    @Override
    public ResponseMessage deleteFile(String fileUrl) {
        FileMngForOSSUtil fileUploadForOSSUtil = new FileMngForOSSUtil(jswebOSSPropertie.getBucket(), null, oSSClient);
        return fileUploadForOSSUtil.deleteFile(fileUrl);

    }

    /**
     * @Author yjzhao
     * @Description 根据OSS 文件存储路径获取文件流
     * @Date 2019/5/18 20:28
     * @Param [fileUrl]
     * @return java.io.InputStream
     **/
    @Override
    public InputStream findFile(String fileUrl) {
        FileMngForOSSUtil fileUploadForOSSUtil = new FileMngForOSSUtil(jswebOSSPropertie.getBucket(), null, oSSClient);
        return fileUploadForOSSUtil.findFile(fileUrl);
    }

    private JsCommFileResourceReq convertToJsCommFileResourceReq(FileVo fileVo) {
        JsCommFileResourceReq jsCommFileResourceReq = new JsCommFileResourceReq();
        jsCommFileResourceReq.setId(fileVo.getId());
        jsCommFileResourceReq.setFileExt(fileVo.getFileExt());
        jsCommFileResourceReq.setFileResourceType(fileVo.getFileResourceType());
        jsCommFileResourceReq.setFileSaveName(fileVo.getFileSaveName());
        jsCommFileResourceReq.setFileSavePath(fileVo.getFileSavePath());
        jsCommFileResourceReq.setFileShowName(fileVo.getFileShowName());
        jsCommFileResourceReq.setFileShowPath(fileVo.getFileShowPath());
        jsCommFileResourceReq.setFileSize(fileVo.getFileSize());
        jsCommFileResourceReq.setFileThumbnailPath(fileVo.getFileThumbnailPath());
        jsCommFileResourceReq.setFileType(fileVo.getFileType());
        return jsCommFileResourceReq;
    }

    @Override
    public ResponseMessage uploadFile(InputStream inputStream, FileType fileType, FileResourceType fileResourceType,String fileName,String fileExt) {

        String baseFileKey = jswebOSSPropertie.getBaseFileKey();
        FileMngForOSSUtil fileUploadForOSSUtil = new FileMngForOSSUtil(jswebOSSPropertie.getBucket(), baseFileKey, oSSClient);
        FileVo fileVo = fileUploadForOSSUtil.fileUpload(inputStream, fileType, fileResourceType,fileName,fileExt);
        //保存数据
        fileVo.setId(IdUtil.simpleUUID());
        apiJsCommFileResourceService.saveJsCommFileResource(convertToJsCommFileResourceReq(fileVo));

        return ResultUtil.success(fileVo, ResultEnum.FILE_UPLOAD_SUCCESS.getCode(), ResultEnum.FILE_UPLOAD_SUCCESS.getMsg());
    }
}
