package com.js.web.service.impl;

import com.js.api.jspay.service.chinapnr.ChinaPNRPayOpenAccountService;
import com.js.api.jspay.service.chinapnr.ChinaPNRPaySubstituteService;
import com.js.common.constant.Constant;
import com.js.common.model.req.*;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.ChinapnrPaySerivce;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.stereotype.Service;

import java.util.Map;


/**
 * @Author zhouyngsheng
 * @Description 汇付国际服务接口
 * @Date 2019/6/13
 **/
@Slf4j
@Service
public class ChinapnrPaySerivceImpl implements ChinapnrPaySerivce {

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ChinaPNRPaySubstituteService chinaPNRPaySubstituteService;

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ChinaPNRPayOpenAccountService chinaPNRPayOpenAccountService;

    /**
     * 提现代发
     * @param chinaPNRSubstituteReq
     * @return
     * @throws Exception
     */
    public ResponseMessage substituteNew(ChinaPNRSubstituteReq chinaPNRSubstituteReq){
        return chinaPNRPaySubstituteService.newSubstituteTrade(chinaPNRSubstituteReq);
    }

    /**
     * 还款汇差服务费代发
     * @param chinaPNRSubstituteReq
     * @return
     * @throws Exception
     */
    public ResponseMessage substituteOld(ChinaPNRSubstituteReq chinaPNRSubstituteReq){
        return chinaPNRPaySubstituteService.oldSubstituteTrade(chinaPNRSubstituteReq);
    }


    /**
     * 个人开户
     * @param chinaPNRPersonalOpenAccountReq
     * @return
     * @throws Exception
     */
    public ResponseMessage opendAccountPersonal(ChinaPNRPersonalOpenAccountReq chinaPNRPersonalOpenAccountReq){
        return chinaPNRPayOpenAccountService.personalOpenAccount(chinaPNRPersonalOpenAccountReq);
    }


    /**
     * 企业开户
     * @param chinaPNREnterpriseOpenAccountReq
     * @return
     * @throws Exception
     */
    public ResponseMessage opendAccountEnterprise(ChinaPNREnterpriseOpenAccountReq chinaPNREnterpriseOpenAccountReq){
        return chinaPNRPayOpenAccountService.enterpriseOpenAccount(chinaPNREnterpriseOpenAccountReq);
    }

    /**
     * 新版代发查询
     * @param chinaPNRSubstituteQueryReq
     * @return
     */
    @Override
    public ResponseMessage queryNewSubstitute(ChinaPNRSubstituteQueryReq chinaPNRSubstituteQueryReq) {
        return chinaPNRPaySubstituteService.queryNewSubstitute(chinaPNRSubstituteQueryReq);
    }

    /**
     * 旧版代发查询
     * @param chinaPNRSubstituteQueryReq
     * @return
     */
    @Override
    public ResponseMessage queryOldSubstitute(ChinaPNRSubstituteQueryReq chinaPNRSubstituteQueryReq) {
        return chinaPNRPaySubstituteService.queryOldSubstitute(chinaPNRSubstituteQueryReq);
    }

    /**
     * 个人开户信息修改
     * @param chinaPNROpenAccountReq
     * @return
     */
    @Override
    public ResponseMessage personalUpdateOpenAccount(ChinaPNRPersonalOpenAccountReq chinaPNROpenAccountReq) {
        return chinaPNRPayOpenAccountService.personalUpdateOpenAccount(chinaPNROpenAccountReq);
    }

    /**
     * 企业开户信息修改
     * @param chinaPNROpenAccountReq
     * @return
     */
    @Override
    public ResponseMessage enterpriseUpdateOpenAccount(ChinaPNREnterpriseOpenAccountReq chinaPNROpenAccountReq) {
        return chinaPNRPayOpenAccountService.enterpriseUpdateOpenAccount(chinaPNROpenAccountReq);
    }

    /**
     * 个人开户信息查询
     * @param chinaPNRQueryOpenAccountReq
     * @return
     */
    @Override
    public ResponseMessage personalQueryOpenAccount(ChinaPNRQueryOpenAccountReq chinaPNRQueryOpenAccountReq) {
        return chinaPNRPayOpenAccountService.personalQueryOpenAccount(chinaPNRQueryOpenAccountReq);
    }

    /**
     * 企业开户信息查询
     * @param chinaPNRQueryOpenAccountReq
     * @return
     */
    @Override
    public ResponseMessage enterpriseQueryOpenAccount(ChinaPNRQueryOpenAccountReq chinaPNRQueryOpenAccountReq) {
        return chinaPNRPayOpenAccountService.enterpriseQueryOpenAccount(chinaPNRQueryOpenAccountReq);
    }

}
