package com.js.web.service;

import com.js.common.enums.RegisterType;
import com.js.common.enums.TradeSubTypeEnum;
import com.js.common.model.req.*;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import org.springframework.web.bind.annotation.RequestBody;

import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;

/**
        * @Description: VAT 缴税 服务接口
        * @Author: liwm
        * @Create: 2019-06-27
        **/
public interface JsPayVatPaymentInfoService {
    /**
     * @Description: 缴税收款人列表
     * @Author liwm
     * @Date 2019/6/27
     **/
    ResponseMessage queryRcvList(String kycNaturalId);

    ResponseMessage queryTreaty(String kycNaturalId);
    ResponseMessage submitTreaty(String kycNaturalId);
    /** 店铺列表
     * @Author liwm
     * @Date 2019/7/2
     **/
    ResponseMessage storeList(KycShowStoreReq kycShowStoreReq);
    /**
     * @Description: vat 缴税 提交
     * @Author liwm
     * @Date 2019/6/28
     **/
    ResponseMessage payVatPayment(JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq,KycNaturalVO optionalKycNaturalVO);
    ResponseMessage addVatPayTradeForNoPass(JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq);

    ResponseMessage queryVatList();
    ResponseMessage testVatChinaPNRTransaction();
    ResponseMessage submitTransactionDetails(String batchNo);
    /**
     * vat 缴税 验证码生成
     * @Author liwm
     * @Date 2019/7/18
     */
    ResponseMessage getSmsCode(String type, ValidateCodeReq validateCodeReq, HttpServletResponse response) throws Exception;

    public ResponseMessage beneficiayAuditNotice(String beneficiaryId,String beneficiaryStatus);
}
