package com.js.web.controller.pay;

import com.js.common.constant.Constant;
import com.js.common.enums.*;
import com.js.common.model.req.*;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsKycNaturalService;
import com.js.web.service.JsKycStoreService;
import com.js.web.service.JsPaySunrateBankService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.Optional;

/**
 * @Author liuh
 * @Description 虚拟账户-js店铺前后端交互controller
 * @Date 2019/5/21
 **/
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class JsStoreController {
    @Autowired
    private JsKycStoreService jsKycStoreService;
    @Autowired
    JsKycNaturalService jsKycNaturalService;
    @Autowired
    JsPaySunrateBankService jsPaySunrateBankService;

    /**
     * 申请虚拟账户-添加店铺操作
     */
    @PostMapping(value = Constant.ApiLoginAuth.AUTHC +"/jsStore/addStore",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage addStore(@Valid @RequestBody KycStoreReq kycStoreReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsKycStoreService.addStore(kycStoreReq,optionalKycNaturalVO.get());
    }

    /**
     * js我的店铺列表
     * @Author liuh
     * @Date 2019/5/23
     */
    @GetMapping(value = Constant.ApiLoginAuth.AUTHC +"/jsStore/storeList")
    public ResponseMessage storeList(KycShowStoreReq kycShowStoreReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsKycStoreService.storeList(kycShowStoreReq,optionalKycNaturalVO.get());
    }

    /**
     * 获取当前用户各个站点申请账户数量，及时时汇率信息
     * @Author liuh
     * @Date 2019/5/29
     */
    @GetMapping(value = Constant.ApiLoginAuth.AUTHC +"/jsStore/findApplyCountNum")
    public ResponseMessage findApplyCountNum(@RequestParam String browserIP, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsKycStoreService.findApplyCountNum(browserIP,optionalKycNaturalVO.get());
    }

    /**
     * 根据店铺ID获取店铺及虚拟账户信息
     * @Author liuh
     * @Date 2019/6/19
     */
    @GetMapping(value = Constant.ApiLoginAuth.AUTHC +"/jsStore/findStoreDetailInfo")
    public ResponseMessage findStoreDetailInfo(@RequestParam String kycStoreId, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsKycStoreService.findStoreDetailInfo(kycStoreId,optionalKycNaturalVO.get());
    }

    /**
     * 编辑保存店铺信息
     * @Author liuh
     * @Date 2019/6/25
     */
    @PostMapping(value = Constant.ApiLoginAuth.AUTHC +"/jsStore/editStore",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage editStore(@Valid @RequestBody KycStoreEditReq kycStoreEditReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsKycStoreService.editStore(kycStoreEditReq,optionalKycNaturalVO.get());
    }

    /**
     * 获取当前登录用户虚拟账户余额>0的账户列表
     * @Author liuh
     * @Date 2019/6/19
     */
    @GetMapping(value = Constant.ApiLoginAuth.AUTHC +"/jsStore/findCanWithdrawStoreList")
    public ResponseMessage findCanWithdrawStoreList(@RequestParam SiteEnum siteCode, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsKycStoreService.findCanWithdrawStoreList(siteCode,optionalKycNaturalVO.get());
    }

    /**
     * 申请提现接口数据初始化
     * @Author liuh
     * @Date 2019/6/23
     */
    @GetMapping(value = Constant.ApiLoginAuth.AUTHC +"/jsStore/initWithdrawInfo")
    public ResponseMessage initWithdrawInfo(@RequestParam SiteEnum storeTheSite,HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsKycStoreService.initWithdrawInfo(storeTheSite,optionalKycNaturalVO.get());
    }

    /**
     * 申请提现接口
     * @Author liuh
     * @Date 2019/6/26
     */
    @PostMapping(value = Constant.ApiLoginAuth.AUTHC +"/jsStore/applyWithdraw",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage applyWithdraw(@Valid @RequestBody ApplyWithdrawTotalReq applyWithdrawTotalReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsPaySunrateBankService.applyWithdraw(applyWithdrawTotalReq,optionalKycNaturalVO.get(),response);
    }

    /**
     * 店铺 token 校验
     * @author liutianyu
     * @date 2019/6/26
     */
    @PostMapping(value = Constant.ApiLoginAuth.AUTHC +"/jsStore/checkStoreToken")
    public ResponseMessage checkStoreToken(@Valid @RequestBody KycStoreCheckTokenReq kycStoreCheckTokenReq){
        return jsKycStoreService.checkStoreToken(kycStoreCheckTokenReq);
    }

    /**
     * 个人中心-我的账户-提现手续费费率
     * @Author liuh
     * @Date 2019/7/5
     */
    @GetMapping(value = Constant.ApiLoginAuth.AUTHC +"/jsStore/showWithdrawCharge")
    public ResponseMessage showWithdrawCharge(HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsKycStoreService.showWithdrawCharge(optionalKycNaturalVO.get());
    }

    /**
     * 交易查询-初始化
     * @Author liuh
     * @Date 2019/7/10
     */
    @GetMapping(value = Constant.ApiLoginAuth.AUTHC +"/jsStore/showTradeInit")
    public ResponseMessage showTradeInit(@RequestParam TradeTypeEnum tradeType,HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsKycStoreService.showTradeInit(tradeType,optionalKycNaturalVO.get());
    }

    /**
     * 根据平台，站点查询申请店铺列表
     * @Author liuh
     * @Date 2019/7/11
     */
    @GetMapping(value = Constant.ApiLoginAuth.AUTHC +"/jsStore/showStoreListByCondition")
    public ResponseMessage showStoreListByCondition(@RequestParam StorePlateformEnum storePlateform,@RequestParam SiteEnum storeTheSite, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsKycStoreService.showStoreListByCondition(storePlateform,storeTheSite,optionalKycNaturalVO.get());
    }
}
