package com.js.web.controller.loan;

import com.js.common.constant.Constant;
import com.js.common.model.req.KycStoreLoanReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsKycNaturalService;
import com.js.web.service.JsStoreLoanService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.Optional;

/**
 * @Author zhouyngsheng
 * @Description 店铺贷入口controller
 * @Date 2019/8/1
 **/
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class StoreLoanController {

    @Autowired
    JsKycNaturalService jsKycNaturalService;

    @Autowired
    JsStoreLoanService jsStoreLoanService;

    /**
     * 店铺贷-贷款整体状况查询
     * @return
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/storeLoan/condition")
    public ResponseMessage condition(HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsStoreLoanService.condition(optionalKycNaturalVO.get().getId());
    }

    /**
     * 查询KEY  Loan展示信息
     * @return
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/storeLoan/getKeyNatural")
    public ResponseMessage getKeyNatural(HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsStoreLoanService.getKeyNatural(optionalKycNaturalVO.get().getId(),optionalKycNaturalVO.get().getRegisterType());
    }

    /**
     * 店铺信息查询
     * @return
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/storeLoan/storeList",consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage storeList(@Valid @RequestBody KycStoreLoanReq kycStoreLoanReq ,HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        kycStoreLoanReq.setKycNaturalId(optionalKycNaturalVO.get().getId());
        return jsStoreLoanService.getStoreLoanList(kycStoreLoanReq);
    }
}












