package com.js.web.controller.loan;

import com.js.common.constant.Constant;
import com.js.common.model.req.JsLoanApplyInfoReq;
import com.js.common.model.req.LoanApplicationReq;
import com.js.common.model.req.LoanCapitalReq;
import com.js.common.model.req.SignContractReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsKycNaturalService;
import com.js.web.service.JsLoanApplicationService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.math.BigDecimal;
import java.util.Optional;

/**
 * @Author zhouyngsheng
 * @Description 贷款申请controller
 * @Date 2019/8/1
 **/
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class LoanApplicationController {

    @Autowired
    private JsLoanApplicationService jsLoanApplicationService;

    @Autowired
    JsKycNaturalService jsKycNaturalService;

    /**
     * 贷款申请
     * @return
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/loan/application",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage application(@Valid @RequestBody JsLoanApplyInfoReq jsLoanApplyInfoReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        jsLoanApplyInfoReq.setKycNaturalId(optionalKycNaturalVO.get().getId());
        return jsLoanApplicationService.loanApply(jsLoanApplyInfoReq);
    }

    /**
     * 借款记录查询
     * @return
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/loan/queryLoan",consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage queryLoan(@Valid @RequestBody LoanApplicationReq loanApplicationReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        loanApplicationReq.setKycNaturalId(optionalKycNaturalVO.get().getId());
        return jsLoanApplicationService.queryLoan(loanApplicationReq);
    }

    /**
     * 查询借款记录详细信息（放款详情需要）
     * @return
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/loan/loanApplicationDetailed")
    public ResponseMessage loanApplicationDetailed(@RequestParam(value = "loanNo",required = false) String loanNo,HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsLoanApplicationService.loanApplicationDetailed(loanNo,optionalKycNaturalVO.get().getId());
    }

    /**
     * 借款记录详情
     * @return
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/loan/loanDetailed",consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage loanDetailed(@RequestParam(value = "loanNo",required = false) String loanNo,HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsLoanApplicationService.loanDetailed(loanNo,optionalKycNaturalVO.get().getId());
    }

    /**
     * 到签署支用合同查询
     * @return
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/loan/loanContract")
    public ResponseMessage loanContract(@RequestParam(value = "loanNo",required = false) String loanNo,HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsLoanApplicationService.loanContract(loanNo,optionalKycNaturalVO.get().getId());
    }

    /**
     * 合同详情查询
     * @return
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/loan/queryContract")
    public ResponseMessage queryContract(@RequestParam(value = "loanNo",required = false) String loanNo,HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsLoanApplicationService.queryContract(loanNo,optionalKycNaturalVO.get().getId());
    }

    /**
     * 合同归档
     * @return
     * @throws Exception
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/loan/signVerification")
    public ResponseMessage signVerification(@RequestParam(value = "loanNo",required = false) String loanNo,HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsLoanApplicationService.signVerification(loanNo,optionalKycNaturalVO.get());
    }

    /**
     * 合同签署
     * @return
     * @throws Exception
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/loan/signContract")
    public ResponseMessage signContract(@Valid @RequestBody SignContractReq signContractReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsLoanApplicationService.signContract(signContractReq, optionalKycNaturalVO.get());
    }

    /**
     * 资金明细查询
     * @return
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/loan/capitalDetailed",consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage capitalDetailed(@Valid @RequestBody LoanCapitalReq loanCapitalReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        loanCapitalReq.setKycNaturalId(optionalKycNaturalVO.get().getId());
        return jsLoanApplicationService.capitalDetailed(loanCapitalReq);
    }

    /**
     * 资金明细详情
     * @return
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/loan/capitalDetailedDetails")
    public ResponseMessage capitalDetailedDetails(@RequestParam(value = "capitalNo",required = false) String capitalNo, @RequestParam(value = "accType",required = false)  String accType){
        return jsLoanApplicationService.capitalDetailedDetails(capitalNo,accType);
    }

}
