package com.js.web.validate.code.sms;

import com.alibaba.fastjson.JSONObject;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.ValidateCodeReq;
import com.js.common.model.vo.ValidateCodeVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResponseUtil;
import com.js.common.util.ResultUtil;
import com.js.web.constant.ValidateCodeConstant;
import com.js.web.validate.code.ValidateCode;
import com.js.web.validate.code.impl.AbstractValidateCodeProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.context.request.ServletWebRequest;

import javax.servlet.http.HttpServletResponse;
import java.util.Optional;

/**
 * 短信验证码发送
 */
@Component("smsValidateCodeProcessor")
public class SmsCodeProcessor extends AbstractValidateCodeProcessor<ValidateCode> {

    /**
     * 短信验证码发送器
     */
    @Autowired
    private SmsCodeSender smsCodeSender;

    @Override
    protected Optional<ValidateCodeVO> send(ValidateCodeReq validateCodeReq, ValidateCode validateCode, HttpServletResponse response){
        String mobile = validateCodeReq.getPhoneNo();
        smsCodeSender.send(mobile, validateCode.getCode());
        ValidateCodeVO validateCodeVO = new ValidateCodeVO();
        validateCodeVO.setMarkStr(validateCode.getMarkStr());
        return Optional.of(validateCodeVO);
    }
}
