package com.js.web.validate.code.image;

import cn.hutool.captcha.CaptchaUtil;
import cn.hutool.captcha.LineCaptcha;
import cn.hutool.core.convert.Convert;
import com.js.common.model.req.ValidateCodeReq;
import com.js.web.properties.ValidateCodeProperties;
import com.js.web.validate.code.ValidateCodeGenerator;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.context.request.ServletWebRequest;

import java.awt.*;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Random;

/**
 * 图片验证码生成器
 */
@Slf4j
public class ImageCodeGenerator implements ValidateCodeGenerator {

    @Autowired
    private ValidateCodeProperties validateCodeProperties;


    /**
      * 浏览器覆盖配置文件，覆盖默认
      * @param validateCodeReq
      * @return
      */
    @Override
    public ImageCode generate(ValidateCodeReq validateCodeReq) {

        ValidateCodeProperties validateCodeProperties = new ValidateCodeProperties();
        ValidateCodeProperties.ImageCodeProperties image = validateCodeProperties.getImage();
        Integer width = image.getWidth();
        Integer height = image.getHeight();
        Integer expireIn = image.getExpireIn();

        if (validateCodeReq != null) {
            if (validateCodeReq.getWidth() != null && validateCodeReq.getWidth().compareTo(0) > 0) {
                width = validateCodeReq.getWidth();
            }
            if (validateCodeReq.getHeight() != null && validateCodeReq.getHeight().compareTo(0) > 0) {
                height = validateCodeReq.getHeight();
            }
        }

        LineCaptcha lineCaptcha = CaptchaUtil.createLineCaptcha(width, height);

        String sRand = lineCaptcha.getCode();
        //图形验证码写出，可以写出到文件，也可以写出到流

        Long markLong = LocalDateTime.now().toInstant(ZoneOffset.of("+8")).toEpochMilli();
        return new ImageCode(lineCaptcha.getImage(), sRand, Convert.toStr(markLong), expireIn);
    }

    /**
     * 生成随机背景条纹
     *
     * @param fc
     * @param bc
     * @return
     */
    private Color getRandColor(int fc, int bc) {
        Random random = new Random();
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + random.nextInt(bc - fc);
        int g = fc + random.nextInt(bc - fc);
        int b = fc + random.nextInt(bc - fc);
        return new Color(r, g, b);
    }

    public ValidateCodeProperties getValidateCodeProperties() {
        return validateCodeProperties;
    }

    public void setValidateCodeProperties(ValidateCodeProperties validateCodeProperties) {
        this.validateCodeProperties = validateCodeProperties;
    }

}
