package com.js.web.validate.code;

import com.js.common.model.req.ValidateCodeReq;
import org.springframework.web.context.request.ServletWebRequest;

/**
 * 校验码存取器
 */
public interface ValidateCodeRepository {
    /**
     * 保存验证码
     * @param code
     * @param validateCodeType
     */
    void save(ValidateCode code, ValidateCodeType validateCodeType);
    /**
     * 获取验证码
     * @param validateCodeReq
     * @param validateCodeType
     * @return
     */
    ValidateCode get(ValidateCodeReq validateCodeReq, ValidateCodeType validateCodeType);
    /**
     * 移除验证码
     * @param validateCodeReq
     * @param codeType
     */
    void remove(ValidateCodeReq validateCodeReq, ValidateCodeType codeType);

}
