package com.js.web.utils;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.w3c.dom.Document;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import java.io.*;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;


public class ServletUtils {

	/**
	 * 
	 * @Title: writerJson
	 * @param response
	 * @param str
	 *            void
	 * @throws
	 */
	public static void writerJson(HttpServletResponse response, String str) {
		writerText(response,"utf-8", "application/x-json", str);
	}

	public static void writerJson(HttpServletResponse response,
			String characterEncoding, String str) {
		writerText(response, characterEncoding, "application/x-json", str);
	}

	/**
	 * 
	 * @Title: writerXml
	 * @param response
	 * @param str
	 *            void
	 * @throws
	 */

	public static void writerXml(HttpServletResponse response, String str) {
		writerText(response, "utf-8", "text/xml", str);
	}

	public static void writerXml(HttpServletResponse response,
			String characterEncoding, String str) {
		writerText(response, characterEncoding, "text/xml", str);
	}

	/**
	 * 
	 * @Title: writerText
	 * @param response
	 * @param str
	 *            void
	 * @throws
	 */

	public static void writerText(HttpServletResponse response, String str) {
		writerText(response, "utf-8", "text/plain", str);
	}

	public static void writerText(HttpServletResponse response,
			String characterEncoding, String str) {
		writerText(response, characterEncoding, "text/plain", str);
	}

	/**
	 * 
	 * @Title: writerText
	 * @param response
	 * @param characterEncoding
	 * @param contentType
	 * @param str
	 *            void
	 * @throws
	 */
	public static void writerText(HttpServletResponse response,
			String characterEncoding, String contentType, String str) {
		PrintWriter writer = null;
		try {
			response.setCharacterEncoding(characterEncoding);
			response.setContentType(contentType);
			writer = response.getWriter();
			writer.print(str);
			writer.flush();
		} catch (IOException e) {
			// throw e;
			System.err.println(e.getLocalizedMessage());
		} finally {
			if (writer != null) {
				writer.close();
			}
		}
	}

	/**
	 * 
	 * @Title: getRequestAttributes
	 * @param request
	 * @return Map<String,Object>
	 * @throws
	 */
	public static Map<String, Object> getRequestAttributes(
			ServletRequest request) {
		Map<String, Object> map = new HashMap<String, Object>();
		loadRequestAttributes(map, request);
		return map;
	}

	/**
	 * 
	 * @Title: loadRequestAttributes
	 * @param map
	 * @param request
	 *            void
	 * @throws
	 */

	@SuppressWarnings("rawtypes")
	public static void loadRequestAttributes(Map<String, Object> map,
			ServletRequest request) {
		Enumeration names = request.getAttributeNames();
		while (names.hasMoreElements()) {
			String name = (String) names.nextElement();
			map.put(name, request.getAttribute(name));
		}
	}

	/**
	 * 
	 * @Title: getRequestParameters
	 * @param request
	 * @return Map<String,Object>
	 * @throws
	 */
	public static Map<String, String> getRequestParameters(
			ServletRequest request) {
		Map<String, String> map = new HashMap<String, String>();
		loadRequestParameters(map, request);
		return map;
	}

	/**
	 * 
	 * @Title: loadRequestParameters
	 * @param map
	 * @param request
	 *            void
	 * @throws
	 */
	@SuppressWarnings("rawtypes")
	public static void loadRequestParameters(Map<String, String> map,
			ServletRequest request) {
		Enumeration names = request.getParameterNames();
		while (names.hasMoreElements()) {
			String name = (String) names.nextElement();
			map.put(name, getRequestParameter(request, name));
		}
	}

	public static String fetchPostByTextPlain(HttpServletRequest request) {
		try {
			BufferedReader reader = request.getReader();
			char[] buf = new char[512];
			int len = 0;
			StringBuffer contentBuffer = new StringBuffer();
			while ((len = reader.read(buf)) != -1) {
				contentBuffer.append(buf, 0, len);
			}
			return contentBuffer.toString();

		} catch (IOException e) {
			e.printStackTrace();
		}
		return "";
	}

	/**
	 * 
	 * @Title: getRequestParameter
	 * @param request
	 * @param name
	 * @return Object
	 * @throws
	 */
	public static String getRequestParameter(ServletRequest request, String name) {
		String[] values = request.getParameterValues(name);
		if (values == null) {
			return null;
		}
		if (values.length == 1) {
			return values[0];
		}
		return values.toString();
	}

	/**
	 * 
	 * @Title: getUrlSuffix
	 * @param url
	 * @return String
	 * @throws
	 */
	public static String getUrlSuffix(String url) {
		if (StringUtils.isBlank(url)) {
			return null;
		}
		if (StringUtils.indexOf(url, "?") != -1) {
			if (StringUtils.endsWith(url, "?")
					|| StringUtils.endsWith(url, "&")) {
				return "";
			} else {
				return "&";
			}
		} else {
			return "?";
		}
	}

	/**
	 * 
	 * @Title: buildParameterString
	 * @param params
	 * @param paramNames
	 * @return String
	 * @throws
	 */
	public static String buildParamString(Map<String, Object> params,
			String[] paramNames) {
		if (ArrayUtils.isEmpty(paramNames)) {
			return "";
		}
		ToStringBuilder builder = new ToStringBuilder(null,
				new MapToStringStyle());
		for (String paramName : paramNames) {
			if (params.containsKey(paramName)) {
				builder.append(paramName, params.get(paramName));
			}
		}
		builder.getStringBuffer().setLength(
				builder.getStringBuffer().length() - 1);
		return builder.toString();
	}

	/**
	 * 
	 * @Title: buildParamString
	 * @param params
	 * @return String
	 * @throws
	 */
	public static String buildParamString(Map<String, Object> params) {
		ToStringBuilder builder = new ToStringBuilder(null,
				new MapToStringStyle());
		for (Map.Entry<String, Object> entry : params.entrySet()) {
			builder.append(entry.getKey(), entry.getValue());
		}
		if (builder.getStringBuffer().length() > 0) {
			builder.getStringBuffer().setLength(
					builder.getStringBuffer().length() - 1);
		}
		return builder.toString();
	}
	
	/**
	 * 
	* @Title: buildParamString
	* @Description: 构建参数串
	* @param sendParams
	* @return    String
	* @throws
	 */
	public static String buildParamString3(Map<String, String> sendParams) {
		// TODO Auto-generated method stub
		ToStringBuilder builder = new ToStringBuilder(null,
				new MapToStringStyle());
		for (Map.Entry<String, String> entry : sendParams.entrySet()) {
			builder.append(entry.getKey(), entry.getValue());
		}
		if(builder.getStringBuffer().length() > 0){
			builder.getStringBuffer().setLength(
				builder.getStringBuffer().length() - 1);
		}
		return builder.toString();
	}

	public static String  recieveData(HttpServletRequest request)  throws Exception{
		BufferedReader br = request.getReader();
		String str="";
		String wholeStr = "";
		while((str = br.readLine()) != null){
			wholeStr += str;
			wholeStr +="\n";
		}
		//wholeStr = wholeStr.replaceAll(" ", "");
		return wholeStr;
	}

	public static Map<String,String> getCallbackMap(String dataReceived){
		Map<String,String> map = new HashMap();
		String[] param =  dataReceived.split("&");
		for(String keyvalue:param){
			String[] pair = keyvalue.split("=");
			if(pair.length==2){
				if(pair[0].equals("signMsg")){
					String last = keyvalue.substring(keyvalue.length()-1,keyvalue.length());
					if(last.equals("=")){
						pair[1] = pair[1] + "=";
					}
				}
				map.put(pair[0], pair[1]);
			}
		}
		return map;
	}

}

/**
 * 
 * @project fx-message-transformation
 * @modify comment
 * @version
 */
class MapToStringStyle extends ToStringStyle {

	private static final long serialVersionUID = 1L;

	MapToStringStyle() {
		setUseClassName(false);
		setContentEnd("");
		setContentStart("");
		setUseIdentityHashCode(false);
		setNullText("");
		setFieldSeparator("&");
		setArrayStart("");
		setArrayEnd("");
	}


}
