package com.js.web.service.impl;

import com.js.api.jsloan.service.ApiStoreLoanService;
import com.js.common.constant.Constant;
import com.js.common.enums.RegisterType;
import com.js.common.model.req.KycStoreLoanReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsStoreLoanService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class JsStoreLoanServiceImpl implements JsStoreLoanService {

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    ApiStoreLoanService apiStoreLoanService;

    @Override
    public ResponseMessage getStoreLoanList(KycStoreLoanReq kycStoreLoanReq) {
        return apiStoreLoanService.getStoreLoanList(kycStoreLoanReq);
    }

    @Override
    public ResponseMessage condition(String kycNatural) {
        return apiStoreLoanService.condition(kycNatural);
    }

    @Override
    public ResponseMessage getKeyNatural(String kycNaturalId, RegisterType registerType) {

        return apiStoreLoanService.getKeyNatural(kycNaturalId,registerType);
    }
}
