package com.js.web.service.impl;

import com.js.api.jsloan.service.ApiJsLoanRiskinfoService;
import com.js.common.constant.Constant;
import com.js.common.model.req.JsLoanRiskInfoReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsLoanRiskService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.stereotype.Service;

/**
 * @Description: 贷款准入
 * @Author: zhouyongsheng
 * @Create: 2019-05-21
 **/
@Slf4j
@Service
public class JsLoanRiskServiceImpl implements JsLoanRiskService {

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiJsLoanRiskinfoService apiJsLoanRiskinfoService;
    /**
     * 贷款准入
     * @param jsLoanRiskInfoReq
     * @return
     */
    @Override
    public ResponseMessage loanRisk(JsLoanRiskInfoReq jsLoanRiskInfoReq) {
        return apiJsLoanRiskinfoService.loanRisk(jsLoanRiskInfoReq);
    }

    @Override
    public ResponseMessage queryAccess(String kycNaturalId,int pageNum,int pageSize) {

        return apiJsLoanRiskinfoService.queryAccess(kycNaturalId,pageNum,pageSize);
    }

    @Override
    public ResponseMessage queryAccessDetails(String riskNo,String kycNaturalId) {

        return apiJsLoanRiskinfoService.queryAccessDetails(riskNo,kycNaturalId);
    }

    @Override
    public ResponseMessage queryLoanRisk(String kycNaturalId) {
        return apiJsLoanRiskinfoService.queryLoanRisk(kycNaturalId);
    }

    @Override
    public ResponseMessage updateLoanRisk(JsLoanRiskInfoReq req) {
        return apiJsLoanRiskinfoService.updateLoanRisk(req);
    }
}
