package com.js.web.service.impl;

import cn.hutool.core.util.IdUtil;
import com.js.api.jsloan.service.ApiJsLoanRiskinfoService;
import com.js.api.jsloan.service.ApiKycLoanBankService;
import com.js.api.jsloan.service.ApiStoreLoanService;
import com.js.api.jspay.service.ApiKycBankService;
import com.js.api.jspay.service.chinapnr.ChinaPNRPayOpenAccountService;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.enums.WayJdBankCheckEnum;
import com.js.common.model.req.ChinaPNRPersonalOpenAccountReq;
import com.js.common.model.req.KycCheckBankReq;
import com.js.common.model.req.KycLoanBankReq;
import com.js.common.model.req.ValidateCodeReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.web.service.JsKycLoanBankService;
import com.js.web.utils.DateUtils;
import com.js.web.validate.code.ValidateCodeProcessorHolder;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * @Author zhouyngsheng
 * @Description 贷款银行卡接口
 * @Date 2019/6/13
 **/
@Slf4j
@Service
public class JsKycLoanBankServiceImpl implements JsKycLoanBankService {

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    ApiKycLoanBankService apiKycLoanBankService;

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    ApiKycBankService apiKycBankService;

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    private
    ApiStoreLoanService apiStoreLoanService;

    @Autowired
    private ValidateCodeProcessorHolder validateCodeProcessorHolder;

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    ApiJsLoanRiskinfoService apiJsLoanRiskinfoService;

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    ChinaPNRPayOpenAccountService chinaPNRPayOpenAccountService;

    @Override
    public ResponseMessage addBank(KycLoanBankReq kycLoanBankReq, HttpServletResponse response, KycNaturalVO kycNaturalVO) {

        kycLoanBankReq.setKycNaturalId(kycNaturalVO.getId());
        //校验验证码是否正确
        ValidateCodeReq validateCodeReq = new ValidateCodeReq();
        validateCodeReq.setMarkStr(kycLoanBankReq.getMarkStr());
        validateCodeReq.setPhoneNo(kycLoanBankReq.getPhone());
        validateCodeReq.setSmsCode(kycLoanBankReq.getSmsCode());
        try{
            validateCodeProcessorHolder.findValidateCodeProcessor("sms").validate(validateCodeReq, response);
        } catch (Exception e) {
            return ResultUtil.error(ResultEnum.VALIDATE_CODE_ERROT);
        }

        //查询准入信息
        ResponseMessage riskResult = apiJsLoanRiskinfoService.queryLoanRisk(kycLoanBankReq.getKycNaturalId());
        Map<String,Object> returnMap = (Map<String, Object>) riskResult.getData();
        if(null == returnMap){
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"仅支持通过贷款申请审核的用户添加此类银行卡");
        }
        if(!returnMap.get("status").equals("1")){
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"仅支持通过贷款申请审核的用户添加此类银行卡");
        }

        //银行卡四要素校验
        KycCheckBankReq kycCheckBankReq = new KycCheckBankReq();
        String idNo = (String)returnMap.get("borrowerIdcard");
        kycCheckBankReq.setCertId(idNo);
        kycCheckBankReq.setAcctPan(kycLoanBankReq.getAccountNo());//银行账号
        kycCheckBankReq.setAcctName(kycLoanBankReq.getAccountName());//开户名称

        kycCheckBankReq.setPhoneNum(kycLoanBankReq.getPhone());
        kycCheckBankReq.setWayJdBankCheckEnum(WayJdBankCheckEnum.FOUR_ELEMENT);
        kycCheckBankReq.setUseReal(false);// 上线前修改为 true
        ResponseMessage responseMessage = apiKycBankService.checkBank(kycCheckBankReq);
        log.info("贷款绑定银行卡四要素校验结果：{}",responseMessage);
        if(!responseMessage.isSuccess()){
            log.info("贷款个人开户四要素验证失败");
            return responseMessage;
        }
        kycLoanBankReq.setIdNo(idNo);
        //查询KYC身份证信息
        ResponseMessage kycMessage = apiStoreLoanService.getKeyNatural(kycNaturalVO.getId(),kycNaturalVO.getRegisterType());
        if(!kycMessage.isSuccess()){
            log.info("贷款个人开户查询KYC失败");
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"贷款个人开户查询KYC失败");
        }
        //查询是否已经绑卡
        ResponseMessage keyLoanBankMessage = apiKycLoanBankService.queryBankFlag(kycLoanBankReq);
        if(!keyLoanBankMessage.isSuccess()){
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"该用户已经绑过该卡");
        }
        //绑卡
        ResponseMessage bankMessage = apiKycLoanBankService.addBank(kycLoanBankReq);
        if(!bankMessage.isSuccess()){
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"绑卡失败");
        }
        //查询是否已经开户
        ResponseMessage accountMessage = apiKycLoanBankService.accountFalg(kycNaturalVO.getId());
        if(!accountMessage.isSuccess()){
            log.info("该用户已经在汇付开过户，无需开其他户 ，直接返回SUCCESS");
            return ResultUtil.success(ResultEnum.SUCCESS);
        }

        Map<String,Object> keyMap = (Map<String,Object>)kycMessage.getData();
        //汇付开户
        ChinaPNRPersonalOpenAccountReq chinaPNROpenAccountReq = new ChinaPNRPersonalOpenAccountReq();
        chinaPNROpenAccountReq.setKycNaturalId(kycLoanBankReq.getKycNaturalId());
        chinaPNROpenAccountReq.setRequestId(IdUtil.simpleUUID());
        chinaPNROpenAccountReq.setPlatformRegTime(DateUtils.getNewDateyyyyMMddhhmmss());
        chinaPNROpenAccountReq.setName(kycLoanBankReq.getAccountName());
        chinaPNROpenAccountReq.setCertType("00");
        chinaPNROpenAccountReq.setCertId(idNo);
        chinaPNROpenAccountReq.setCertExpDateEnd(DateUtils.StrToStr(keyMap.get("effectiveEndTime").toString()));
        chinaPNROpenAccountReq.setMobileNumber(kycLoanBankReq.getPhone());
        chinaPNROpenAccountReq.setAddress(keyMap.get("address").toString());
        chinaPNROpenAccountReq.setEmail(kycNaturalVO.getEmail());
        chinaPNROpenAccountReq.setBankCode(kycLoanBankReq.getBankCode());
        chinaPNROpenAccountReq.setBankAcct(kycLoanBankReq.getAccountNo());
        chinaPNROpenAccountReq.setAcctName(kycLoanBankReq.getAccountName());
        chinaPNROpenAccountReq.setCertPhotoCopyF(keyMap.get("borrowerIdCardFront").toString());
        chinaPNROpenAccountReq.setCertPhotoCopyB(keyMap.get("borrowerIdCardBack").toString());
        chinaPNROpenAccountReq.setJsOpenAccountNo(IdUtil.simpleUUID());
        chinaPNRPayOpenAccountService.personalOpenAccount(chinaPNROpenAccountReq);
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage queryBankList(String kycNaturalId) {
        return apiKycLoanBankService.queryBankList(kycNaturalId);
    }
}
