package com.js.web.service.impl;

import com.alibaba.fastjson.JSON;
import com.js.api.jspay.service.ApiKycCertiMainLandCompanyService;
import com.js.api.jspay.service.ApiKycSunrateService;
import com.js.api.jspay.service.ApiSunrateRegisterService;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.CertiStatusEnum;
import com.js.common.enums.EmailRemindTypeEnum;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.CertiMainLandCompanyReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.IdCardUtils;
import com.js.common.util.ResultUtil;
import com.js.web.mq.RabbitMQSender;
import com.js.web.service.IMailService;
import com.js.web.service.JsKycCertiMainLandCompanyService;
import com.js.web.service.JsKycSunrateBeneficiaryService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/**
 * @Description: 大陆企業操作服务实现
 * @Author: liuh
 * @Create: 2019-05-18
 **/
@Slf4j
@Service
public class JsKycCertiMainLandCompanyServiceImpl implements JsKycCertiMainLandCompanyService {
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiKycCertiMainLandCompanyService apiKycCertiMainLandCompanyService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiKycSunrateService apiKycSunrateService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiSunrateRegisterService apiSunrateRegisterService;
    @Autowired
    JsKycSunrateBeneficiaryService jsKycSunrateBeneficiaryService;
    @Autowired
    RabbitMQSender rabbitMQSender;
    @Autowired
    IMailService iMailService;
    @Value("${jsweb.validate.idcard.needmatch}")
    private Boolean needmatch;

    @Override
    public ResponseMessage certiMainLandCompanyAdd(CertiMainLandCompanyReq certiMainLandCompanyReq, KycNaturalVO kycNaturalVO) {
        log.info("大陆企业实名入参：{}", certiMainLandCompanyReq);
        if(!CertiStatusEnum.NO_SUBMIT.equals(kycNaturalVO.getCertificationStatus()) && !CertiStatusEnum.FIRST_TRIAL_FAILURE.equals(kycNaturalVO.getCertificationStatus())){
            log.error("{},{}用户已提交实名信息:{}",kycNaturalVO.getId(),kycNaturalVO.getRegisterType(),kycNaturalVO.getCertificationStatus());
            return ResultUtil.error(ResultEnum.CERTI_ALREADY_SUBMIT);
        }
        if(StringUtils.isNotBlank(certiMainLandCompanyReq.getId()) && kycNaturalVO.getId().equals(certiMainLandCompanyReq.getId())){
            log.error("当前登录用户：{}，需要编辑用户：{}，不符合",kycNaturalVO.getId(),certiMainLandCompanyReq.getId());
            return ResultUtil.error(ResultEnum.ERROR);
        }
        if(!kycNaturalVO.getEmailActiveFlag()){
            log.error("邮箱未激活,不可以提交实名信息");
            return ResultUtil.error(ResultEnum.EMAIL_NOT_ACTIVE);
        }
        if(certiMainLandCompanyReq.getBizLicenseExpDateStart().getTime() > certiMainLandCompanyReq.getBizLicenseExpDateEnd().getTime()){
            return ResultUtil.error(ResultEnum.MESSAGE_EXIST.getCode(), ResultEnum.MESSAGE_EXIST.getMsg() + ",营业执照有效期错误");
        }
        if(StringUtils.isBlank(certiMainLandCompanyReq.getId())) {
            boolean existsFlag = apiKycCertiMainLandCompanyService.verifyCertiMainLandComapnyExists(certiMainLandCompanyReq.getUnifiedSocialCreditCode());
            if (existsFlag) {
                return ResultUtil.error(ResultEnum.MESSAGE_EXIST.getCode(), ResultEnum.MESSAGE_EXIST.getMsg());
            }
        }
        boolean longFlag = certiMainLandCompanyReq.getLongFlag();
        if(!longFlag && (null == certiMainLandCompanyReq.getEffectiveEndTime()
            || certiMainLandCompanyReq.getEffectiveEndTime().getTime() < certiMainLandCompanyReq.getEffectiveStartTime().getTime())){
            return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(), ResultEnum.NO_MUST_PARAM_ERROR.getMsg());
        }
        if(longFlag){
            certiMainLandCompanyReq.setEffectiveEndTime(CommonConstant.longFormatDate());
        }
        try {
            if(needmatch) {
                Boolean match = IdCardUtils.isMatch(certiMainLandCompanyReq.getLegalRepresentativeName(), certiMainLandCompanyReq.getLegalRepresentativeIdNo());
                log.error("姓名：{}，身份证号：{}，认证结果:{}", certiMainLandCompanyReq.getLegalRepresentativeName(), certiMainLandCompanyReq.getLegalRepresentativeIdNo(), match);
                if (!match) {
                    return ResultUtil.error(ResultEnum.ERROR.getCode(), ResultEnum.ERROR.getMsg() + "姓名与身份证不符,请核实");
                }
            }
            ResponseMessage operPersonResponseMessage = null;
            if(StringUtils.isBlank(certiMainLandCompanyReq.getId())){
                log.info("保存大陆企业-实名信息-开始");
                operPersonResponseMessage = apiKycCertiMainLandCompanyService.certiMainLandCompanyAdd(certiMainLandCompanyReq, kycNaturalVO);
                log.info("保存大陆企业-实名信息-结束返回结果:{},描述信息:{}", operPersonResponseMessage.isSuccess(), operPersonResponseMessage.getMsg());
            }else{
                log.info("保存大陆企业-编辑实名信息-开始");
                operPersonResponseMessage = apiKycCertiMainLandCompanyService.certiMainLandCompanyUpdate(certiMainLandCompanyReq, kycNaturalVO);
                log.info("保存大陆企业-编辑实名信息-结束返回结果:{},描述信息:{}", operPersonResponseMessage.isSuccess(), operPersonResponseMessage.getMsg());
            }
            return operPersonResponseMessage;
        }catch (Exception ex){
            log.error("大陆企业实名认证处理异常", ex);
            iMailService.sendRemindEmail("大陆企业实名认证处理异常", "大陆企业实名认证处理异常:" + JSON.toJSONString(ex), EmailRemindTypeEnum.WARN_EMAIL);
            return ResultUtil.error(ResultEnum.ERROR);
        }
    }
}
