package com.js.web.service.impl;

import com.alibaba.fastjson.JSON;
import com.js.api.jspay.service.*;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.*;
import com.js.common.model.req.*;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.IdCardUtils;
import com.js.common.util.ResultUtil;
import com.js.web.mq.RabbitMQSender;
import com.js.web.service.IMailService;
import com.js.web.service.JsKycCertiHKCompanyService;
import com.js.web.service.JsKycSunrateBeneficiaryService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/**
 * @Description: 香港企业操作服务实现
 * @Author: liuh
 * @Create: 2019-05-31
 **/
@Slf4j
@Service
public class JsKycCertiHKCompanyServiceImpl implements JsKycCertiHKCompanyService {
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiKycCertiHKCompanyService apiKycCertiHKCompanyService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiKycSunrateService apiKycSunrateService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiSunrateRegisterService apiSunrateRegisterService;
    @Autowired
    JsKycSunrateBeneficiaryService jsKycSunrateBeneficiaryService;
    @Autowired
    RabbitMQSender rabbitMQSender;
    @Autowired
    IMailService iMailService;
    @Value("${jsweb.validate.idcard.needmatch}")
    private Boolean needmatch;

    @Override
    public ResponseMessage certiHKCompanyAdd(KycCertiHKCompanyReq kycCertiHKCompanyReq, KycNaturalVO kycNaturalVO) {
        log.info("香港企业实名入参：{}", kycCertiHKCompanyReq);
        if(!CertiStatusEnum.NO_SUBMIT.equals(kycNaturalVO.getCertificationStatus()) && !CertiStatusEnum.FIRST_TRIAL_FAILURE.equals(kycNaturalVO.getCertificationStatus())){
            log.error("{},{}用户已提交实名信息:{}",kycNaturalVO.getId(),kycNaturalVO.getRegisterType(),kycNaturalVO.getCertificationStatus());
            return ResultUtil.error(ResultEnum.CERTI_ALREADY_SUBMIT);
        }
        if(StringUtils.isNotBlank(kycCertiHKCompanyReq.getId()) && kycNaturalVO.getId().equals(kycCertiHKCompanyReq.getId())){
            log.error("当前登录用户：{}，需要编辑用户：{}，不符合",kycNaturalVO.getId(),kycCertiHKCompanyReq.getId());
            return ResultUtil.error(ResultEnum.ERROR);
        }
        if(!kycNaturalVO.getEmailActiveFlag()){
            log.error("邮箱未激活,不可以提交实名信息");
            return ResultUtil.error(ResultEnum.EMAIL_NOT_ACTIVE);
        }
        if(StringUtils.isBlank(kycCertiHKCompanyReq.getId())) {
            boolean existsFlag = apiKycCertiHKCompanyService.verifyCertiHKCompanyExists(kycCertiHKCompanyReq.getCompanyRegisteredCertificateNo());
            if (existsFlag) {
                return ResultUtil.error(ResultEnum.MESSAGE_EXIST.getCode(), ResultEnum.MESSAGE_EXIST.getMsg());
            }
        }
        if(CertiFileType.ID_CARD.equals(kycCertiHKCompanyReq.getCertiCardType())){
            if(null == kycCertiHKCompanyReq.getEffectiveStartTime() || null == kycCertiHKCompanyReq.getLongFlag()){
                log.info("香港企业实名入参不正确-effectiveStartTime:{},longFlag:{}",kycCertiHKCompanyReq.getEffectiveStartTime(),kycCertiHKCompanyReq.getLongFlag());
                return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(), ResultEnum.NO_MUST_PARAM_ERROR.getMsg());
            }
            boolean longFlag = kycCertiHKCompanyReq.getLongFlag();
            if(!longFlag && (null == kycCertiHKCompanyReq.getEffectiveEndTime()
                    || kycCertiHKCompanyReq.getEffectiveEndTime().getTime() < kycCertiHKCompanyReq.getEffectiveStartTime().getTime())){
                return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(), ResultEnum.NO_MUST_PARAM_ERROR.getMsg());
            }
            if(longFlag){
                kycCertiHKCompanyReq.setEffectiveEndTime(CommonConstant.longFormatDate());
            }
            if(needmatch) {
                Boolean match = IdCardUtils.isMatch(kycCertiHKCompanyReq.getDirectorName(), kycCertiHKCompanyReq.getDirectorIdNo());
                log.error("姓名：{}，身份证号：{}，认证结果:{}", kycCertiHKCompanyReq.getDirectorName(), kycCertiHKCompanyReq.getDirectorIdNo(), match);
                if (!match) {
                    return ResultUtil.error(ResultEnum.ERROR.getCode(), ResultEnum.ERROR.getMsg() + "姓名与身份证不符,请核实");
                }
            }
        }
        try {
            ResponseMessage operPersonResponseMessage = null;
            if(StringUtils.isBlank(kycCertiHKCompanyReq.getId())){
                log.info("编辑香港企业-实名信息-开始");
                operPersonResponseMessage = apiKycCertiHKCompanyService.certiHKCompanyAdd(kycCertiHKCompanyReq, kycNaturalVO);
                log.info("编辑香港企业-实名信息-结束返回结果:{},描述信息:{}", operPersonResponseMessage.isSuccess(), operPersonResponseMessage.getMsg());
            }else{
                log.info("编辑香港企业-实名信息-开始");
                operPersonResponseMessage = apiKycCertiHKCompanyService.certiHKCompanyUpdate(kycCertiHKCompanyReq, kycNaturalVO);
                log.info("编辑香港企业-实名信息-结束返回结果:{},描述信息:{}", operPersonResponseMessage.isSuccess(), operPersonResponseMessage.getMsg());
            }
            return operPersonResponseMessage;
        }catch (Exception ex){
            log.error("香港企业实名认证处理异常", ex);
            iMailService.sendRemindEmail("香港企业实名认证处理异常", "香港企业实名认证处理异常:" + JSON.toJSONString(ex), EmailRemindTypeEnum.WARN_EMAIL);
            return ResultUtil.error(ResultEnum.ERROR);
        }
    }
}
