package com.js.web.service.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.js.api.jsloan.service.fadada.ApiFadadaService;
import com.js.common.constant.Constant;
import com.js.common.enums.FileResourceType;
import com.js.common.enums.FileType;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.FadadaSignContractResultReq;
import com.js.common.model.req.FadadaUploadContractReq;
import com.js.common.model.resp.FadadaContractVO;
import com.js.common.model.vo.FileVo;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.web.service.FadadaService;
import com.js.web.service.JsFileSerivce;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.*;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
public class FadadaServiceImpl implements FadadaService {

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    ApiFadadaService apiFadadaService;

    @Autowired
    JsFileSerivce jsFileSerivce;

    @Override
    public ResponseMessage sign(String jsLoanRiskInfoId, String jsLoanApplyInfoId) {
        return apiFadadaService.sign(jsLoanRiskInfoId, jsLoanApplyInfoId);
    }

    @Override
    public ResponseMessage archiveContract2(String kycNatualId, String loanNo) {
        return apiFadadaService.archiveContract2(kycNatualId, loanNo);
    }

    @Override
    public ResponseMessage getUnSignContractByLoanNo(String loanNo) {
        return apiFadadaService.getUnSignContractByLoanNo(loanNo);
    }

    @Override
    public ResponseMessage getSignStatus(String loanNo) {
        return apiFadadaService.getSignStatus(loanNo);
    }

    @Override
    public ResponseMessage getSignContractResultByReturnUrl(FadadaSignContractResultReq fadadaSignContractResultReq) {
        return apiFadadaService.getSignContractResultByReturnUrl(fadadaSignContractResultReq);
    }

    @Override
    public ResponseMessage uploadContract2(FadadaUploadContractReq fadadaUploadContractReq) {
        return apiFadadaService.uploadContract2(fadadaUploadContractReq);
    }

    @Override
    public ResponseMessage uploadContractToOSS(String loanNo) {
        ResponseMessage fadadaContractVOByLoanNo = apiFadadaService.getFadadaContractVOByLoanNo(loanNo);
        List<FadadaContractVO> voList = (List<FadadaContractVO>) fadadaContractVOByLoanNo.getData();
        // 上传到阿里云 OSS
        for (FadadaContractVO fadadaContractVO : voList) {
            // 向法大大请求文件
            HttpResponse response = HttpRequest.get(fadadaContractVO.getDowLoadUrl()).execute();
            String contentType = response.header("Content-Type");
            byte[] bytes = response.bodyBytes();
            if ("application/pdf".equals(contentType)) {
                // 是 pdf 代表下载成功,上传至阿里云
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
                ResponseMessage responseMessage = jsFileSerivce.uploadFile(byteArrayInputStream, FileType.FILE_PDF,
                        FileResourceType.CONTRACT_FILE, fadadaContractVO.getDocTitle(), "pdf");
                if (responseMessage.getCode() != ResultEnum.FILE_UPLOAD_SUCCESS.getCode()) {
                    return responseMessage;
                } else {
                    FileVo fileVo = (FileVo) responseMessage.getData();
                    fadadaContractVO.setFileSavePath(fileVo.getFileSavePath());
                    ResponseMessage responseMessage1 = apiFadadaService.updateContract(fadadaContractVO);
                    if (!responseMessage1.isSuccess()) {
                        return responseMessage1;
                    }
                }
            } else {
                String s = null;
                try {
                    s = new String(bytes, "utf-8");
                } catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                log.error(s);
                return ResultUtil.error(s, ResultEnum.ERROR);
            }
        }
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage getContractViewUrl(String loanNo) {
        ResponseMessage fadadaContractVOByLoanNo = apiFadadaService.getFadadaContractVOByLoanNo(loanNo);
        List<FadadaContractVO> voList = (List<FadadaContractVO>) fadadaContractVOByLoanNo.getData();
        return ResultUtil.success(voList, ResultEnum.SUCCESS);
    }
}
