package com.js.web.service;

import com.js.common.enums.GenerateFileType;
import com.js.common.enums.TradeSubTypeEnum;
import com.js.common.enums.TradeTypeEnum;
import com.js.common.model.req.*;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @Description: 交易明细查询接口
 * @Author: liuh
 * @Create: 2019-05-21
 **/
public interface JsPayTradeService {
    /**
     * @Description: 交易明细列表
     * @Author liuh
     * @Date 2019/6/11
     **/
    ResponseMessage tradeList(JsTradeListReq jsTradeListReq, KycNaturalVO kycNaturalVO);

    /**
     * @Description:  交易明细列表-交易详情
     * @Author liuh
     * @Date 2019/6/15
     **/
    ResponseMessage tradeDetail(TradeTypeEnum tradeType, String tradeId);

    /**
     * @Description: 资金明细列表
     * @Author liuh
     * @Date 2019/7/11
     **/
    ResponseMessage fundDetailList(JsTradeFundReq jsTradeFundReq, KycNaturalVO kycNaturalVO);

    /**
     * @Description: 资金明细列表-交易详情
     * @Author liuh
     * @Date 2019/7/12
     **/
    ResponseMessage fundDetail(TradeTypeEnum tradeType,String fundDetailId);

    /**
     * @Author liuh
     * @Description 文件生成记录表查询
     * @Date 2019/7/15
     **/
    ResponseMessage generateFileRecordList(GenerateFileType generateFileType,KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 文件生成记录存储
     * @Date 2019/7/15
     **/
    ResponseMessage generateTradeRecord(JsTradeListReq jsTradeListReq,KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 下载生成文件
     * @Date 2019/7/22
     **/
    ResponseMessage downloadGenerateRecord(GenerateFileRecordReq generateFileRecordReq,HttpServletResponse response,KycNaturalVO kycNaturalVO);
}
