package com.js.web.service;

import com.js.common.enums.SiteEnum;
import com.js.common.enums.StorePlateformEnum;
import com.js.common.enums.TradeSubTypeEnum;
import com.js.common.enums.TradeTypeEnum;
import com.js.common.model.req.*;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;

/**
 * @Description: 申请虚拟账户-添加店铺服务接口
 * @Author: liuh
 * @Create: 2019-05-21
 **/
public interface JsKycStoreService {
    /**
     * @Author liuh
     * @Date 2019/5/21
     **/
    ResponseMessage addStore(KycStoreReq kycStoreReq, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Date 2019/5/23
     **/
    ResponseMessage storeList(KycShowStoreReq kycShowStoreReq, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 获取各个站点申请账户数量
     * @Date 2019/5/29
     **/
    ResponseMessage findApplyCountNum(String browserIP,KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 根据店铺ID获取店铺及虚拟账户信息
     * @Date 2019/6/19
     **/
    ResponseMessage findStoreDetailInfo(String kycStoreId, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 编辑保存店铺信息
     * @Date 2019/6/25
     **/
    ResponseMessage editStore(KycStoreEditReq kycStoreEditReq, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 获取当前登录用户虚拟账户余额>0的账户列表
     * @Date 2019/6/19
     **/
    ResponseMessage findCanWithdrawStoreList(SiteEnum siteEnum, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 申请提现接口数据初始化
     * @Date 2019/6/23
     **/
    ResponseMessage initWithdrawInfo(SiteEnum storeTheSite,KycNaturalVO kycNaturalVO);

    /**
     * 校验用户授权店铺的 token 是否有效。
     *
     * @author liutianyu
     * @param kycStoreCheckTokenReq
     * @return
     */
    ResponseMessage checkStoreToken(KycStoreCheckTokenReq kycStoreCheckTokenReq);

    /**
     * @Author liuh
     * @Description 个人中心-我的账户-提现手续费费率
     * @Date 2019/7/5
     **/
    ResponseMessage showWithdrawCharge(KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 交易查询-初始化
     * @Date 2019/7/10
     **/
    ResponseMessage showTradeInit(TradeTypeEnum tradeType, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 根据平台，站点查询申请店铺列表
     * @Date 2019/7/11
     **/
    ResponseMessage showStoreListByCondition(StorePlateformEnum storePlateform,SiteEnum storeTheSite, KycNaturalVO kycNaturalVO);
}
