package com.js.web.service;

import com.js.common.model.req.*;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Optional;

/**
 * @ClassName: JsKycNaturalService
 * @Description: 用户服务接口
 * @Author: yjzhao
 * @Create: 2019-05-16  09:17
 **/
public interface JsKycNaturalService {
    /**
     * @Author yjzhao
     * @Description email是否已被使用
     * @Date 2019/5/16 10:09
     * @Param [email]
     * @return com.js.common.model.vo.common.ResponseMessage
     **/
    ResponseMessage verifyEmailExists(String email);

    /**
     * @Author yjzhao
     * @Description phoneNo是否已被使用
     * @Date 2019/5/16 10:10
     * @Param [phoneNo]
     * @return com.js.common.model.vo.common.ResponseMessage
     **/
    ResponseMessage verifyMobileExists(String phoneNo);

    /**
     * @Author yjzhao
     * @Description 根据手机号获取Kyc账户相关信息
     * @Date 2019/5/21 14:29
     * @Param [phoneNo]
     * @return com.js.common.model.vo.KycNaturalVO
     **/
    KycNaturalVO findKycNaturalVOByPhoneNo(String phoneNo);

    /**
     * @Author yjzhao
     * @Description 根据邮箱获取Kyc账户相关信息
     * @Date 2019/5/21 14:29
     * @Param [phoneNo]
     * @return com.js.common.model.vo.KycNaturalVO
     **/
    KycNaturalVO findKycNaturalVOByEmail(String email);

    /**
     * @Author yjzhao
     * @Description 注册用户
     * @Date 2019/5/16 10:11
     * @Param [regiserKycNatural, request, response]
     * @return com.js.common.model.vo.common.ResponseMessage
     **/
    ResponseMessage register(RegiserKycNaturalReq regiserKycNatural, HttpServletRequest request, HttpServletResponse response);

    /**
     * @Author yjzhao
     * @Description 密码加密获取公钥
     * @Date 2019/5/19 14:31
     * @Param [phoneNo, request, response]
     * @return com.js.common.model.vo.common.ResponseMessage
     **/
    ResponseMessage getPwdKey(String phoneNo, HttpServletRequest request, HttpServletResponse response);

    /**
     * @Author yjzhao
     * @Description 密码登陆
     * @Date 2019/5/21 14:21
     * @Param [mobile, pwd, request, response]
     * @return com.js.common.model.vo.common.ResposeMessage
     **/
    ResponseMessage loginByPwd(LoginKycNaturalReq loginKycNaturalReq, HttpServletRequest request, HttpServletResponse response);

    /**
     * @Author yjzhao
     * @Description 登出操作
     * @Date 2019/5/21 17:24
     * @Param [request, response]
     * @return com.js.common.model.vo.common.ResponseMessage
     **/
    ResponseMessage logOut(HttpServletRequest request, HttpServletResponse response);

    /**
     * @Author yjzhao
     * @Description 根据请求获取Kyc账户信息
     * @Date 2019/5/21 21:18
     * @Param [request, response]
     * @return java.util.Optional<com.js.common.model.vo.KycNaturalVO>
     **/
    Optional<KycNaturalVO> findKycNaturalVOByWebToken(HttpServletRequest request, HttpServletResponse response) throws Exception;

    /**
     * @Author yjzhao
     * @Description 更改密码
     * @Date 2019/5/23 15:12
     * @Param [chPwdReq, request, response]
     * @return com.js.common.model.vo.common.ResponseMessage
     **/
    ResponseMessage changePwd(ChPwdReq chPwdReq, HttpServletRequest request, HttpServletResponse response);

    /**
     * @Author liuh
     * @Description 更改密码
     * @Date 2019/7/19
     **/
    ResponseMessage changePwd(ChPwdReq chPwdReq);

    /**
     * @Author yjzhao
     * @Description 忘记密码-图片验证码
     * @Date 2019/5/23 18:00
     * @Param [forgetPwd, request, response]
     * @return com.js.common.model.vo.common.ResponseMessage
     **/
    ResponseMessage forgetPwd4Image(ForgetPwdReq forgetPwd, HttpServletRequest request, HttpServletResponse response);

    /**
     * @Author yjzhao
     * @Description 忘记密码-手机验证码
     * @Date 2019/5/23 21:22
     * @Param [forgetPwd, request, response]
     * @return com.js.common.model.vo.common.ResponseMessage
     **/
    ResponseMessage forgetPwd4SMS(ForgetPwdReq forgetPwd, HttpServletRequest request, HttpServletResponse response);

    /**
     * @Author yjzhao
     * @Description 邮箱绑定验证码校验
     * @Date 2019/5/24 20:44
     * @Param [validateCodeReq, request, response]
     * @return com.js.common.model.vo.common.ResponseMessage
     **/
    ResponseMessage emailValidate(ValidateCodeReq validateCodeReq, HttpServletRequest request, HttpServletResponse response);

    /**
     * 根据登录用户token获取数据库个人信息
     *  @Date 2019/6/24
     */
    KycNaturalVO findKycNaturalVO(KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 修改手机号
     * @Date 2019/7/8
     **/
    ResponseMessage changeMoblie(KycSecurityMobileReq kycSecurityMobileReq, KycNaturalVO kycNaturalVO,HttpServletRequest request,  HttpServletResponse response);

    /**
     * @Author liuh
     * @Description 修改邮箱
     * @Date 2019/7/8
     **/
    ResponseMessage changeEmail(KycSecurityEmailReq kycSecurityEmailReq,KycNaturalVO kycNaturalVO, HttpServletResponse response);
}
