package com.js.web.service;

import com.js.common.model.req.FadadaSignContractResultReq;
import com.js.common.model.req.FadadaUploadContractReq;
import com.js.common.model.vo.common.ResponseMessage;

public interface FadadaService {

    /**
     * 开始签署合同
     * @param jsLoanRiskInfoId
     * @param jsLoanApplyInfoId
     * @return
     */
    ResponseMessage sign(String jsLoanRiskInfoId, String jsLoanApplyInfoId);

    /**
     * 合同归档
     * @param kycNatualId
     * @param loanNo
     * @return
     */
    ResponseMessage archiveContract2(String kycNatualId, String loanNo);

    /**
     * 目前用户签署状态。
     * @param loanNo
     * @return total 总共需要用户签署的数量, unsigned: 已经签署的数量, status 合同状态 0:可以签署的新合同 1:不可以签新合同
     */
    ResponseMessage getUnSignContractByLoanNo(String loanNo);

    /**
     * 获取未签署的合同地址。
     * @param loanNo
     * @return
     */
    ResponseMessage getSignStatus(String loanNo);

    /**
     * 合同签署结果。同步通知
     */
    ResponseMessage getSignContractResultByReturnUrl(FadadaSignContractResultReq fadadaSignContractResultReq);

    /**
     * 合同上传
     */
    ResponseMessage uploadContract2(FadadaUploadContractReq fadadaUploadContractReq);

    /**
     * 该方法需要在合同归档后进行调用。
     *
     * @param loanNo
     */
    ResponseMessage uploadContractToOSS(String loanNo);

    /**
     * 获取合同查看 url。
     *
     * @param loanNo
     */
    ResponseMessage getContractViewUrl(String loanNo);
}
