package com.js.web.controller.web;

import com.js.common.constant.Constant;
import com.js.common.model.req.LoginKycNaturalReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsKycNaturalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;

/**
 * @ClassName: LoginController
 * @Description: 登陆相关Controller
 * @Author: yjzhao
 * @Create: 2019-05-21  14:18
 **/
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE},
        consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class LoginController {

    @Autowired
    private JsKycNaturalService jsKycNaturalService;

    /**
     * @Author yjzhao
     * @Description 密码登陆
     * @Date 2019/5/21 14:20
     * @Param [mobile, pwd, key, request, response]
     * @return ResponseMessage
     **/
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/login/pwd")
    public ResponseMessage loginByPwd(@Valid @RequestBody LoginKycNaturalReq loginKycNaturalReq,
                                      HttpServletRequest request, HttpServletResponse response) {
        return jsKycNaturalService.loginByPwd(loginKycNaturalReq, request, response);
    }

}
