package com.js.web.controller.web;

import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.KycSecurityEmailReq;
import com.js.common.model.req.KycSecurityMobileReq;
import com.js.common.model.req.KycSecurityReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.web.service.JsKycNaturalService;
import com.js.web.service.JsKycSecurityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.Optional;

/**
 * @Author liuh
 * @Description natural表交互
 * @Date 2019/6/24
 **/
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class KycNaturalController {

    @Autowired
    private JsKycNaturalService jsKycNaturalService;
    @Autowired
    JsKycSecurityService jsKycSecurityService;

    /**
     * 通过数据库查找当前登录用户信息
     * @return
     */
    @GetMapping(value = Constant.ApiLoginAuth.AUTHC +"/kycNatural/findNaturalInfo")
    public ResponseMessage findNaturalInfo(HttpServletRequest request,HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> kycNaturalVOByWebToken = jsKycNaturalService.findKycNaturalVOByWebToken(request, response);
        KycNaturalVO kycNaturalVO = jsKycNaturalService.findKycNaturalVO(kycNaturalVOByWebToken.get());
        return null == kycNaturalVO ? ResultUtil.error(ResultEnum.USER_NOT_EXIST) : ResultUtil.success(kycNaturalVO);
    }

    /**
     * 保存用户密保问题
     * @Author liuh
     * @Date 2019/7/8
     */
    @PostMapping(value = Constant.ApiLoginAuth.AUTHC +"/kycNaturalSecurity/saveSecurityByKyc",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage saveSecurityByKyc(@Valid @RequestBody KycSecurityReq kycSecurityReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> kycNaturalVOByWebToken = jsKycNaturalService.findKycNaturalVOByWebToken(request, response);
        KycNaturalVO kycNaturalVO = jsKycNaturalService.findKycNaturalVO(kycNaturalVOByWebToken.get());
        return jsKycSecurityService.saveSecurityByKyc(kycSecurityReq,kycNaturalVO);
    }

    /**
     * 查询密保
     * @Author liuh
     * @Date 2019/7/8
     */
    @GetMapping(value = Constant.ApiLoginAuth.AUTHC +"/kycNaturalSecurity/findSecurityByKyc")
    public ResponseMessage findSecurityByKyc(HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> kycNaturalVOByWebToken = jsKycNaturalService.findKycNaturalVOByWebToken(request, response);
        KycNaturalVO kycNaturalVO = jsKycNaturalService.findKycNaturalVO(kycNaturalVOByWebToken.get());
        return jsKycSecurityService.findsSecurityByKyc(kycNaturalVO);
    }

    /**
     * 更改手机号
     * @Author liuh
     * @Date 2019/7/8
     */
    @PostMapping(value = Constant.ApiLoginAuth.AUTHC +"/kycNaturalSecurity/changeMoblie",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage changeMoblie(@Valid @RequestBody KycSecurityMobileReq kycSecurityMobileReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> kycNaturalVOByWebToken = jsKycNaturalService.findKycNaturalVOByWebToken(request, response);
        KycNaturalVO kycNaturalVO = jsKycNaturalService.findKycNaturalVO(kycNaturalVOByWebToken.get());
        return jsKycNaturalService.changeMoblie(kycSecurityMobileReq,kycNaturalVO,request,response);
    }

    /**
     * 更改邮箱
     * @Author liuh
     * @Date 2019/7/8
     */
    @PostMapping(value = Constant.ApiLoginAuth.AUTHC +"/kycNaturalSecurity/changeEmail",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage changeEmail(@Valid @RequestBody KycSecurityEmailReq kycSecurityEmailReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> kycNaturalVOByWebToken = jsKycNaturalService.findKycNaturalVOByWebToken(request, response);
        KycNaturalVO kycNaturalVO = jsKycNaturalService.findKycNaturalVO(kycNaturalVOByWebToken.get());
        return jsKycNaturalService.changeEmail(kycSecurityEmailReq,kycNaturalVO,response);
    }
}
