package com.js.web.controller.loan;

import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.JsLoanBillFilePageReq;
import com.js.common.model.req.JsLoanBillFileReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.web.service.JsKycNaturalService;
import com.js.web.service.JsLoanBillFileService;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Optional;

/**
 * @Author zhouyngsheng
 * @Description 贷款对账文件controller
 * @Date 2019/8/1
 **/
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class LoanBillFileController {

    @Autowired
    JsLoanBillFileService jsLoanBillFileService;

    @Autowired
    JsKycNaturalService jsKycNaturalService;

    /**
     * 对账文件申请查询
     * @return
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/loanBill/applyQuery",consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage applyQuery(@Valid @RequestBody JsLoanBillFilePageReq jsLoanBillFilePageReq , HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        jsLoanBillFilePageReq.setKycNaturalId(optionalKycNaturalVO.get().getId());
        return jsLoanBillFileService.applyQuery(jsLoanBillFilePageReq);
    }

    /**
     * 对账文件申请
     * @return
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/loanBill/applyOperation",consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage applyOperation(@Valid @RequestBody JsLoanBillFileReq jsLoanBillFileReq , HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        jsLoanBillFileReq.setKycNaturalId(optionalKycNaturalVO.get().getId());
        return jsLoanBillFileService.applyOperation(jsLoanBillFileReq);
    }

    /**
     * 对账文件下载
     * @return
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/loanBill/download")
    public ResponseMessage download(@RequestParam(value = "loanBillNo",required = false) String loanBillNo,  HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        ResponseMessage message =  jsLoanBillFileService.download(optionalKycNaturalVO.get().getId(),loanBillNo);
        if(message.isSuccess()){
            //excel文件名
            String fileName = "贷款对账单"+System.currentTimeMillis()+".xls";
            HSSFWorkbook wb = (HSSFWorkbook)message.getData();
            try {
                try {
                    fileName = new String(fileName.getBytes(),"ISO8859-1");
                } catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                response.setContentType("application/octet-stream;charset=ISO8859-1");
                response.setHeader("Content-Disposition", "attachment;filename="+ fileName);
                response.addHeader("Pargam", "no-cache");
                response.addHeader("Cache-Control", "no-cache");
                OutputStream os = response.getOutputStream();
                wb.write(os);
                os.flush();
                os.close();
            } catch (Exception ex) {
                ex.printStackTrace();
                return ResultUtil.error(ResultEnum.ERROR.getCode(),"文件下载失败");
            }
        }
        return ResultUtil.success(ResultEnum.SUCCESS.getCode(),"文件下载成功");
    }

}
