package com.js.web.controller.loan;

import com.js.common.constant.Constant;
import com.js.common.model.req.JsLoanRiskInfoReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsKycNaturalService;
import com.js.web.service.JsLoanRiskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.Optional;

/**
 * @Author zhouyngsheng
 * @Description 贷款准入controller
 * @Date 2019/8/1
 **/
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class LoanAccessController {

    @Autowired
    private JsLoanRiskService jsLoanRiskService;

    @Autowired
    JsKycNaturalService jsKycNaturalService;

    /**
     * 贷款准入
     * @param jsLoanRiskInfoReq
     * @param request
     * @param response
     * @return
     * @throws Exception
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/loan/access",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage access(@Valid @RequestBody JsLoanRiskInfoReq jsLoanRiskInfoReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        jsLoanRiskInfoReq.setKycNaturalId(optionalKycNaturalVO.get().getId());
        jsLoanRiskInfoReq.setRegisterType(optionalKycNaturalVO.get().getRegisterType().getEnumCode()+"");
        return jsLoanRiskService.loanRisk(jsLoanRiskInfoReq);
    }

    /**
     * 贷款准入查询
     * @return
     * @throws Exception
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/loan/queryAccess")
    public ResponseMessage queryAccess(@RequestParam Integer pageNum, @RequestParam Integer pageSize, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsLoanRiskService.queryAccess(optionalKycNaturalVO.get().getId(),pageNum,pageSize);
    }

    /**
     * 贷款准入详情查询
     *
     * @return
     * @throws Exception
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/loan/queryAccessDetails")
    public ResponseMessage queryAccessDetails(@RequestParam(value = "riskNo") String riskNo,HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsLoanRiskService.queryAccessDetails(riskNo,optionalKycNaturalVO.get().getId());
    }

    /**
     * 贷款准入信息查询
     *
     * @return
     * @throws Exception
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/loan/queryLoanRisk")
    public ResponseMessage queryLoanRisk(HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsLoanRiskService.queryLoanRisk(optionalKycNaturalVO.get().getId());
    }

    /**
     * 贷款准入修改
     * @param jsLoanRiskInfoReq
     * @param request
     * @param response
     * @return
     * @throws Exception
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/loan/updateLoanRisk",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage updateLoanRisk(@Valid @RequestBody JsLoanRiskInfoReq jsLoanRiskInfoReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        jsLoanRiskInfoReq.setKycNaturalId(optionalKycNaturalVO.get().getId());
        jsLoanRiskInfoReq.setRegisterType(optionalKycNaturalVO.get().getRegisterType().getEnumCode()+"");
        return jsLoanRiskService.updateLoanRisk(jsLoanRiskInfoReq);
    }
}
