package com.js.web.controller.loan;

import com.js.common.constant.Constant;
import com.js.common.model.req.FadadaSignContractResultReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.FadadaService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;


/**
 * 法大大电子签章
 *
 * @author liutianyu
 */
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class FadadaController {

    @Autowired
    FadadaService fadadaService;

    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/fadada/sign")
    public ResponseMessage sign(String jsLoanRiskInfoId, String jsLoanApplyInfoId) {
        return fadadaService.sign(jsLoanRiskInfoId, jsLoanApplyInfoId);
    }

    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/fadada/archiveContract2")
    public ResponseMessage archiveContract2(String kycNatualId, String loanNo) {
        return fadadaService.archiveContract2(kycNatualId, loanNo);
    }

    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/fadada/getSignStatus")
    public ResponseMessage getSignStatus(String loanNo) {
        return fadadaService.getSignStatus(loanNo);
    }

    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/fadada/getUnSignContractByLoanNo")
    public ResponseMessage getUnSignContractByLoanNo(String loanNo) {
        return fadadaService.getUnSignContractByLoanNo(loanNo);
    }

    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/fadada/getSignContractResultByReturnUrl")
    public ResponseMessage getSignContractResultByReturnUrl(FadadaSignContractResultReq fadadaSignContractResultReq) {
        return fadadaService.getSignContractResultByReturnUrl(fadadaSignContractResultReq);
    }

//    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/fadada/uploadContract")
//    public ResponseMessage uploadContract(String loanNo, String filePath) {
//        return fadadaService.uploadContract(loanNo, filePath);
//    }

}
