package com.js.web.controller.loan;


import cn.hutool.json.JSONObject;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.web.service.EnterpriseInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;


/**
 * 向借贷系统提供企业相关信息
 *
 * @author liutianyu
 */
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class EnterpriseInfoController {

    @Autowired
    EnterpriseInfoService enterpriseInfoService;

    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/enterpriseInfo/getEnterpriseInfo/{kycNaturalId}")
    public ResponseMessage getFullDetailsByName(@PathVariable("kycNaturalId") String kycNaturalId){
        // 加一个临时挡板
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("js-2001", 17);
        jsonObject.put("js-2002", "北京");
        jsonObject.put("js-2003", true);
        jsonObject.put("js-2004", false);
        jsonObject.put("js-2005", false);
        jsonObject.put("js-2006", false);
        jsonObject.put("js-2007", false);
        jsonObject.put("js-2008", false);
        jsonObject.put("js-2009", "北京");
        return ResultUtil.success(jsonObject, ResultEnum.QUERY_SUCCESS);
        //return enterpriseInfoService.getFullDetailsByName(qiChaChaEnterpriseInfoReq);
    }
}
