package com.js.web.validate.code.impl;


import cn.hutool.core.util.StrUtil;
import com.js.common.model.req.ValidateCodeReq;
import com.js.common.util.RedisUtil;
import com.js.web.constant.ValidateCodeConstant;
import com.js.web.validate.code.ValidateCode;
import com.js.web.validate.code.ValidateCodeRepository;
import com.js.web.validate.code.ValidateCodeType;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Author yjzhao
 * @Description 验证码验证存储实现类
 * @Date 2019/4/8 11:09
 * @Param 
 * @return 
 **/
@Component
@Slf4j
public class RedisValidateCodeRepository implements ValidateCodeRepository {



    /** 操作redis得工具类 */
    @Autowired
    private RedisUtil redisUtil;


    @Override
    public void save(ValidateCode code, ValidateCodeType validateCodeType) {
        StringBuffer redisCodeSavekey = new StringBuffer(ValidateCodeConstant.REDIS_CODE_KEY_PREFIX);
        redisCodeSavekey.append(validateCodeType.toString().toLowerCase());
        redisCodeSavekey.append(StrUtil.UNDERLINE);
        redisCodeSavekey.append(code.getMarkStr());
        redisUtil.setex(redisCodeSavekey.toString(),
                code.getCode(),
                code.getExpireIn());

    }

    @Override
    public ValidateCode get(ValidateCodeReq validateCodeReq, ValidateCodeType validateCodeType) {
        return new ValidateCode(redisUtil.get(getRedisCodeKey(validateCodeReq, validateCodeType)));
    }

    @Override
    public void remove(ValidateCodeReq validateCodeReq, ValidateCodeType validateCodeType) {
        redisUtil.del(getRedisCodeKey(validateCodeReq, validateCodeType));
    }

    /**
     * 构建验证码翻入 redis 得可以
     *
     * @return
     */
    private String getRedisCodeKey(ValidateCodeReq validateCodeReq, ValidateCodeType validateCodeType)  {
        String markStr = "last";
        try {
            markStr = validateCodeReq.getMarkStr();
            //markStr = ServletRequestUtils.getStringParameter(request.getRequest(),
            //        ValidateCodeConstant.DEFAULT_PARAMETER_NAME_MARKSTR);
        } catch (Exception e) {
            log.info(ValidateCodeConstant.DEFAULT_PARAMETER_NAME_MARKSTR + " param is not exit.");
        }

        return ValidateCodeConstant.REDIS_CODE_KEY_PREFIX  +  validateCodeType.toString().toLowerCase() + StrUtil.UNDERLINE + markStr;
    }
}
