package com.js.web.validate.code.image;

import com.js.common.model.req.ValidateCodeReq;
import com.js.common.model.vo.ValidateCodeVO;
import com.js.web.validate.code.impl.AbstractValidateCodeProcessor;
import org.springframework.stereotype.Component;
import sun.misc.BASE64Encoder;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletResponse;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.util.Optional;

/**
 *
 */
@Component("imageValidateCodeProcessor")
public class ImageCodeProcessor  extends AbstractValidateCodeProcessor<ImageCode> {
    /**
     * 发送图形验证码，将其写到相应中
     * @param validateCode
     * @throws Exception
     */
    @Override
    protected Optional<ValidateCodeVO> send(ValidateCodeReq validateCodeReq, ImageCode validateCode, HttpServletResponse response) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        BufferedImage image = validateCode.getImage();

        ImageIO.write(image, "JPEG", outputStream);

        BASE64Encoder encoder = new BASE64Encoder();
        String imgByBase64Str = encoder.encode(outputStream.toByteArray());
        String markStr = validateCode.getMarkStr();
        ValidateCodeVO validateCodeVO = new ValidateCodeVO();
        validateCodeVO.setMarkStr(markStr);
        validateCodeVO.setImgByBase64Str(imgByBase64Str);
        //TODO 上线前删除
        validateCodeVO.setCode(validateCode.getCode());
        return Optional.of(validateCodeVO);
    }
}
