package com.js.web.validate.code.email;

import com.js.common.enums.ResultEnum;
import com.js.common.util.ResultUtil;
import com.js.web.service.impl.IMailServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @Author yjzhao
 * @Description 发送邮箱验证码
 * @Date 2019/4/8 15:11
 * @Param
 * @return
 **/
@Slf4j
public class DefaultEmailCodeSender implements EmailCodeSender {

    @Autowired
    private IMailServiceImpl mailService;

    @Override
    public void send(String email, String code) {
        log.warn("邮箱验证码发送器(EmailCodeSender)");
        try {
            StringBuffer emailHtmlBStr = new StringBuffer("<body style=\"text-align: center;margin-left: auto;margin-right: auto;\">\n");
            emailHtmlBStr.append(" <div id=\"welcome\" style=\"text-align: center;position: absolute;\" >\n");
            emailHtmlBStr.append("      <h3>及时雨Pay邮箱绑定</h3>\n");
            emailHtmlBStr.append("      <span>邮箱验证码：</span>");
            emailHtmlBStr.append("     <div style=\"text-align: center; padding: 10px;font-size: 24px; color:#FF7F00;\">\n");
            emailHtmlBStr.append("     <span>");
            emailHtmlBStr.append(code);
            emailHtmlBStr.append("     </span>");
            emailHtmlBStr.append("     </div>\n");
            emailHtmlBStr.append(" </div>\n" + "</body>");


            mailService.sendHtmlMail(email,"绑定邮箱验证", emailHtmlBStr.toString());
        }catch (Exception ex){
            ex.printStackTrace();
        }

        String rtnCode = "";
        log.info("向邮箱:{}, 发送验证码:{}, 返回:{}" ,email ,code ,rtnCode);
    }
}
