package com.js.web.utils;

import cn.xsshome.taip.face.TAipFace;
import cn.xsshome.taip.ocr.TAipOcr;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.js.common.enums.CertiFileType;
import com.js.common.enums.OcrType;
import com.js.common.enums.ResultEnum;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.Base64Utils;
import org.springframework.web.multipart.MultipartFile;

@Slf4j
public class TAipUtil {
    private static String appId = "2117232408";
    private static String appKey = "gsSvG848hBDZeqQt";

    public static ResponseMessage ocrIdentify(MultipartFile file, CertiFileType certiFileType){
        String result;
        try {
            TAipOcr tAipOcr = new TAipOcr(appId,appKey);
            TAipFace tAipFace = new TAipFace(appId,appKey);
            log.info("ocr识别影像信息-开始:{}",certiFileType);
            byte[] image = file.getBytes();
            if (CertiFileType.CARD_FRONT_IMAGE.equals(certiFileType) || CertiFileType.CARD_BACK_IMAGE.equals(certiFileType)) {
                //身份证正反面识别方法
                result = tAipOcr.idcardOcr(image, certiFileType.getEnumCode());
            }else if(CertiFileType.BUSINESS_LICENSE_IMAGE.equals(certiFileType)){
                //企业营业执照识别方法
                result = tAipOcr.bizlicenseOcr(image);
            }else if(CertiFileType.CARD_HANDID_IMAGE.equals(certiFileType)){
                //手持身份证影像
                result = handInFaceCompare(file,tAipOcr,tAipFace);
            }else {
                return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR);
            }
            JSONObject queryJson = JSONObject.parseObject(result);
            String ret = queryJson.getString("ret");
            if("0".equals(ret)){
                log.info("识别成功:{}",queryJson);
                JSONObject resultJson = processResult(queryJson.getJSONObject("data"),certiFileType);
                return ResultUtil.success(resultJson);
            }else{
                log.error("识别失败:{}",queryJson.get("msg"));
            }
        }catch (Exception ex){
            log.error("请求ocr识别异常", ex);
            return ResultUtil.error(ResultEnum.ERROR);
        }
        return ResultUtil.error(ResultEnum.ERROR);
    }

    private static JSONObject processResult(JSONObject resultJson,CertiFileType certiFileType){
        if (CertiFileType.CARD_FRONT_IMAGE.equals(certiFileType)) {
            resultJson.remove("frontimage");
        }else if(CertiFileType.CARD_BACK_IMAGE.equals(certiFileType)){
            resultJson.remove("backimage");
        }else if(CertiFileType.BUSINESS_LICENSE_IMAGE.equals(certiFileType)){

        }else if(CertiFileType.CARD_HANDID_IMAGE.equals(certiFileType)){

        }
        return resultJson;
    }

    private static String handInFaceCompare(MultipartFile file,TAipOcr tAipOcr,TAipFace tAipFace) throws Exception{
        //身份证正反面识别方法
        byte[] image = file.getBytes();
        String idcardOcr = tAipOcr.idcardOcr(image, OcrType.ID_CARD_FRONT.getCode());
        JSONObject queryJson = JSONObject.parseObject(idcardOcr);
        String ret = queryJson.getString("ret");
        if("0".equals(ret)){
            log.info("手持对比身份证正面识别成功:{}",queryJson);
            JSONObject jsonObject = queryJson.getJSONObject("data");
            String frontimage = jsonObject.getString("frontimage");
            byte[] bytesSource = Base64Utils.decodeFromString(frontimage);
            //人脸对比
            String resultCompare = tAipFace.faceCompare(bytesSource,file.getBytes());
            return resultCompare;
        }else{
            log.error("手持对比身份证正面识别失败:{}",queryJson.get("msg"));
        }
        return idcardOcr;
    }

    public static void main(String[] args){
        try{
            String appId1 = "2117232408";
            String appKey1 = "gsSvG848hBDZeqQt";

            String imagePath = "C:\\Users\\EDZ\\Desktop\\14.jpg";

            TAipOcr client = new TAipOcr(appId1, appKey1);

            String result = client.bizlicenseOcr(imagePath);

            JSONObject queryJson = JSONObject.parseObject(result);
            JSONObject resultJson = queryJson.getJSONObject("data");
            JSONArray jsonArray = resultJson.getJSONArray("item_list");

            for(int i = 0 ; i < jsonArray.size(); i ++){
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                System.out.println(jsonObject);
            }



//            byte[] image = FileUtil.readFileByBytes(file);
            // 初始化
//            TAipOcr client = new TAipOcr(appId1, appKey1);
////            byte[] image = null;// FileUtil.readFileByBytes(imagePath);
//            String imagePath = "C:\\Users\\EDZ\\Desktop\\3.jpg";
//            String idcardOcr = client.idcardOcr(imagePath, 0);//身份证正面(图片)识别;
//            JSONObject jsonObject = JSONObject.parseObject(idcardOcr);
//            String ret = jsonObject.getString("ret");
//            if("0".equals(ret)){
//                System.out.println("---------解析成功-------------");
//            }else{
//                String msg = jsonObject.getString("msg");
//                System.out.println("---------解析失败------------- " + msg);
//            }
//            String result = client.idcardOcr(image , 1);//身份证反面(国徽)识别;
//
//            TAipFace clientFace = new TAipFace(appId, appKey);
//            //            String imagePath = "C:\\Users\\EDZ\\Desktop\\2.jpg";
////            String imagePath = "C:\\Users\\EDZ\\Desktop\\3.jpg";
//            String imagePath = "C:\\Users\\EDZ\\Desktop\\8.jpg";
//            String result = client.idcardOcr(imagePath, 0);//身份证正面(图片)识别;  入参手持身份证照片
//            JSONObject frontResult = JSONObject.parseObject(result);
////            System.out.println(frontResult);
//            JSONObject jsonObject = frontResult.getJSONObject("data");
//
//            String frontimage = jsonObject.getString("frontimage");
//
//            byte[] bytes = Base64Utils.decodeFromString(frontimage);
//
//            byte[] bytes1 = FileUtils.readFileToByteArray(new File(imagePath));
//            //人脸对比
//            String result1 = clientFace.faceCompare(bytes,bytes1);
//            System.out.println(result1);
        }catch (Exception ex){
            ex.printStackTrace();
        }
    }
}
