package com.js.web.service.impl;

import cn.hutool.core.net.NetUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.js.api.jspay.service.ApiSunrateTradePriceService;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.SiteEnum;
import com.js.common.model.req.SunrateTradePriceReq;
import com.js.common.model.vo.JsPaySunrateTradeQueryPriceVo;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.KycShowApplyVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.web.service.SunrateTradePriceService;
import lombok.Builder;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @Description: 寻汇虚拟银行账户服务实现
 * @Author: liuh
 * @Create: 2019-05-21
 **/
@Slf4j
@Service
public class SunrateTradePriceServiceImpl implements SunrateTradePriceService {
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    private ApiSunrateTradePriceService apiSunrateTradePriceService;

    @Override
    public ResponseMessage xhTradeQueryPrice(String browserIP,KycNaturalVO kycNaturalVO){
        log.info("寻汇-询价开始,浏览器IP:{}",browserIP);
        List<Map> maps = apiSunrateTradePriceService.findSiteByNaturalId(kycNaturalVO.getId());
        if(CollectionUtils.isEmpty(maps)){
            return ResultUtil.success();
        }
        String orgCode = apiSunrateTradePriceService.findOrgCode(kycNaturalVO.getId(),kycNaturalVO.getRegisterType());
        for(Map<String,Object> map : maps){
            SunrateTradePriceReq sunrateTradePriceReq = new SunrateTradePriceReq();
            sunrateTradePriceReq.setOrgCode(orgCode);
            sunrateTradePriceReq.setBuyCur(CommonConstant.TRADE_CURRENCY_CNH);
            sunrateTradePriceReq.setSellCur(SiteEnum.valueOf(map.get("storesitecode").toString()).getCurrency());
            sunrateTradePriceReq.setTxnMode(CommonConstant.TXN_MODE_SELL);
            sunrateTradePriceReq.setTxnAmt(new BigDecimal(1));
            sunrateTradePriceReq.setBrowserIP(browserIP);
            ResponseMessage responseMessage = apiSunrateTradePriceService.xhTradeQueryPrice(sunrateTradePriceReq);
            log.info("寻汇-询价结束-返回结果:{},描述信息:{}",responseMessage.isSuccess(),responseMessage.getMsg());
            if(!responseMessage.isSuccess()){
                continue;
            }
            Object data = responseMessage.getData();
            Map<String,String> resultMap = (Map)data;
            map.putAll(resultMap);
        }
        return ResultUtil.success(maps);
    }

    @Override
    public JsPaySunrateTradeQueryPriceVo xhQueryPrice(BigDecimal txnAmt,String transinCur, String orgCode){
        SunrateTradePriceReq sunrateTradePriceReq = new SunrateTradePriceReq();
        sunrateTradePriceReq.setOrgCode(orgCode);
        sunrateTradePriceReq.setBuyCur(CommonConstant.TRADE_CURRENCY_CNH);
        sunrateTradePriceReq.setSellCur(transinCur);
        sunrateTradePriceReq.setTxnMode(CommonConstant.TXN_MODE_BUY);
        sunrateTradePriceReq.setTxnAmt(txnAmt);
        sunrateTradePriceReq.setBrowserIP(NetUtil.getLocalhostStr());
        ResponseMessage responseMessage = apiSunrateTradePriceService.xhTradeQueryPrice(sunrateTradePriceReq);
        log.info("寻汇-询价结束-返回结果:{},描述信息:{}",responseMessage.isSuccess(),responseMessage.getMsg());
        if(responseMessage.isSuccess()){
            JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(responseMessage.getData()));
            return jsonObject.toJavaObject(JsPaySunrateTradeQueryPriceVo.class);
        }
        log.info("询价结果未成功，返回空值");
        return null;
    }
}
