package com.js.web.service.impl;


import com.js.api.jsloan.service.ApiStatisticsInfoService;
import com.js.common.constant.Constant;
import com.js.common.model.req.JsLoanStatisticsInfoReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.StatisticsInfoService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class StatisticsInfoServiceImpl implements StatisticsInfoService {

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    ApiStatisticsInfoService apiStatisticsInfoService;

    @Override
    public ResponseMessage getPlatformKycInfo(JsLoanStatisticsInfoReq jsLoanStatisticsInfoReq) {
        return apiStatisticsInfoService.getPlatformKycInfo(jsLoanStatisticsInfoReq);
    }

    @Override
    public ResponseMessage getPlatformStoreInfoList(JsLoanStatisticsInfoReq jsLoanStatisticsInfoReq) {
        return apiStatisticsInfoService.getPlatformStoreInfoList(jsLoanStatisticsInfoReq);
    }

    @Override
    public ResponseMessage getPlatformStatisticsInfo(String kycNaturalId) {
        return apiStatisticsInfoService.getPlatformStatisticsInfo(kycNaturalId);
    }
}
