package com.js.web.service.impl;

import com.js.api.jspay.service.ApiJsPayStationOrganInfoService;
import com.js.api.jspay.service.ApiJsPayVatPaymentInfoService;
import com.js.api.jspay.service.ApiSunrateBeneficiaryService;
import com.js.api.jspay.service.ApiSunrateTradePriceService;
import com.js.common.constant.Constant;
import com.js.common.enums.BeneficiaryTypeEnum;
import com.js.common.enums.RegisterType;
import com.js.common.model.req.JsPayVatPaymentInfoReq;
import com.js.common.model.req.JsPayVatPaymentRcvListReq;
import com.js.common.model.req.KycSunrateBeneficiaryReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsPayVatPaymentInfoService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class JsPayVatPaymentInfoServiceImpl implements JsPayVatPaymentInfoService {
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    private ApiJsPayVatPaymentInfoService apiJsPayVatPaymentInfoService;

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    private ApiJsPayStationOrganInfoService apiJsPayStationOrganInfoService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    private ApiSunrateBeneficiaryService apiSunrateBeneficiaryService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    private ApiSunrateTradePriceService apiSunrateTradePriceService;

    @Override
    public ResponseMessage queryRcvList(JsPayVatPaymentRcvListReq jsPayVatPaymentRcvListReq) {
//        if(CountryCodeEnum.ENGLAND.getEnumCode().equals(jsPayVatPaymentRcvListReq.getTaxStationCountry())
//            || CountryCodeEnum.ENGLAND.getEnumCode().equals(jsPayVatPaymentRcvListReq.getTaxStationCountry())){
//        }
        return apiJsPayVatPaymentInfoService.queryRcvList(jsPayVatPaymentRcvListReq);
    }

    @Override
    public ResponseMessage payVatPayment(JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq, RegisterType registerType) {
        log.info("查询是否需要添加受益人");
        String taxStationId = jsPayVatPaymentInfoReq.getTaxStationId();
        String orgCode = apiSunrateTradePriceService.findOrgCode(jsPayVatPaymentInfoReq.getKycNaturalId(),registerType);
        if(StringUtils.isEmpty(taxStationId)){
            //添加受益人
            addBeneficiary(jsPayVatPaymentInfoReq);

        }else{
            String beneficiaryStatus = apiJsPayStationOrganInfoService.queryVatStationStatus(taxStationId);
            if("2".equals(beneficiaryStatus) || StringUtils.isEmpty(beneficiaryStatus)){ // 受益人审核未通过，需重新添加申请
                //添加受益人
                // addBeneficiary(jsPayVatPaymentInfoReq);
            }else if("0".equals(beneficiaryStatus)){ // 受益人审核中

            }else if("1".equals(beneficiaryStatus)){ //受益人审核通过的

            }
        }

        return null;
    }

    private ResponseMessage addBeneficiary(JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq){
        KycSunrateBeneficiaryReq kycSunrateBeneficiaryReq = new KycSunrateBeneficiaryReq();
//        kycSunrateBeneficiaryReq.setOrgCode(jsPayVatPaymentInfoReq.getOrgCode());
//        kycSunrateBeneficiaryReq.setAba(jsPayVatPaymentInfoReq.);
        kycSunrateBeneficiaryReq.setBankName(jsPayVatPaymentInfoReq.getBankName());
        String taxStationType = jsPayVatPaymentInfoReq.getTaxStationType();
        kycSunrateBeneficiaryReq.setBeneficiaryAcctNo("0".equals(taxStationType)?jsPayVatPaymentInfoReq.getBankCardNo():jsPayVatPaymentInfoReq.getIban());
        kycSunrateBeneficiaryReq.setBeneficiaryAddr("");
//        kycSunrateBeneficiaryReq.setBeneficiaryId();
        kycSunrateBeneficiaryReq.setBeneficiaryType(BeneficiaryTypeEnum.VAT_PAYMENT);
        kycSunrateBeneficiaryReq.setBeneficiaryName(jsPayVatPaymentInfoReq.getCusName());
        kycSunrateBeneficiaryReq.setBrowserIP(jsPayVatPaymentInfoReq.getBrowserIP());
        kycSunrateBeneficiaryReq.setCountryCode(jsPayVatPaymentInfoReq.getTaxStationCountry());
        kycSunrateBeneficiaryReq.setCur(jsPayVatPaymentInfoReq.getVatPayCur());
        kycSunrateBeneficiaryReq.setIban(jsPayVatPaymentInfoReq.getIban());
        kycSunrateBeneficiaryReq.setRouteType(jsPayVatPaymentInfoReq.getRouteType());
        kycSunrateBeneficiaryReq.setSwiftcode(jsPayVatPaymentInfoReq.getSortCode());
        kycSunrateBeneficiaryReq.setRemark("");
        ResponseMessage responseMessage = apiSunrateBeneficiaryService.beneficiaryCreate(kycSunrateBeneficiaryReq,null);
        return responseMessage;
    }
}
