package com.js.web.service.impl;

import com.alibaba.fastjson.JSON;
import com.js.api.jspay.service.ApiJsPaySunrateBankTradeInService;
import com.js.api.jspay.service.ApiJsPaySunrateTradeLockPriceService;
import com.js.common.constant.Constant;
import com.js.common.enums.ProcessStatusEnum;
import com.js.common.enums.ResultEnum;
import com.js.common.enums.TradeSubTypeEnum;
import com.js.common.model.req.JsTradeListReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.web.service.JsPayTradeService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.stereotype.Service;

/**
 * @Description: 寻汇虚拟银行账户服务实现
 * @Author: liuh
 * @Create: 2019-05-21
 **/
@Slf4j
@Service
public class JsPayTradeServiceImpl implements JsPayTradeService {
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    private ApiJsPaySunrateBankTradeInService apiJsPaySunrateBankTradeInService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    private ApiJsPaySunrateTradeLockPriceService apiJsPaySunrateTradeLockPriceService;

    @Override
    public ResponseMessage tradeList(JsTradeListReq jsTradeListReq, KycNaturalVO kycNaturalVO) {
        log.info("查询交易明细开始：{}", JSON.toJSONString(jsTradeListReq));
        if(TradeSubTypeEnum.SUB_TRADE_IN.equals(jsTradeListReq.getTradeSubTypeEnum())){
            //入账交易查询
            jsTradeListReq.setProcessStatusEnum(ProcessStatusEnum.TRADE_PROCESSED);
            return apiJsPaySunrateBankTradeInService.tradeInList(jsTradeListReq, kycNaturalVO);
        }else if(TradeSubTypeEnum.WITHDRAW.equals(jsTradeListReq.getTradeSubTypeEnum())
            || TradeSubTypeEnum.REPAYMENT.equals(jsTradeListReq.getTradeSubTypeEnum())){
            //提现交易查询 或者 还款交易查询
            jsTradeListReq.setProcessStatusEnum(ProcessStatusEnum.TRADE_PROCESSED);
            return apiJsPaySunrateTradeLockPriceService.withdrawAndRefundList(jsTradeListReq,kycNaturalVO);
        }else{
            log.info("不支持的交易查询类型");
        }
        log.info("查询交易明细结束");
        return ResultUtil.error(ResultEnum.ERROR);
    }

    @Override
    public ResponseMessage tradeDetail(TradeSubTypeEnum tradeSubTypeEnum, String tradeId) {
        log.info("查询交易详情-开始：{},{}",tradeSubTypeEnum,tradeId);
        if(TradeSubTypeEnum.SUB_TRADE_IN.equals(tradeSubTypeEnum)){
            //入账交易详情查询
            return apiJsPaySunrateBankTradeInService.tradeInDetail(tradeId);
        }else if(TradeSubTypeEnum.WITHDRAW.equals(tradeSubTypeEnum)
                || TradeSubTypeEnum.REPAYMENT.equals(tradeSubTypeEnum)){
            //提现交易详情查询 或者 还款交易详情查询
            return apiJsPaySunrateTradeLockPriceService.withdrawAndRefundDetail(tradeId);
        }else{
            log.info("不支持的交易详情查询类型");
        }
        log.info("查询交易详情-结束");
        return ResultUtil.error(ResultEnum.ERROR);
    }
}
