package com.js.web.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.js.api.jspay.service.ApiJsPaySunrateBankService;
import com.js.api.jspay.service.ApiKycBankService;
import com.js.api.jspay.service.ApiKycCertiLinkFileService;
import com.js.api.jspay.service.ApiSunrateTradePriceService;
import com.js.api.jspay.service.chinapnr.ChinaPNRPayOpenAccountService;
import com.js.common.constant.Constant;
import com.js.common.enums.*;
import com.js.common.model.req.*;
import com.js.common.model.vo.KycBankVO;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.web.service.JsKycNaturalService;
import com.js.web.service.JsKycSunrateBeneficiaryService;
import com.js.web.service.JsPaySunrateBankService;
import com.js.web.validate.code.ValidateCodeException;
import com.js.web.validate.code.ValidateCodeProcessorHolder;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Result;
import java.math.BigDecimal;
import java.util.*;

/**
 * @Description: js_pay_sunrate_bank交互操作
 * @Author: liuh
 * @Create: 2019-06-27
 **/
@Slf4j
@Service
public class JsPaySunrateBankServiceImpl implements JsPaySunrateBankService {
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiKycBankService apiKycBankService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiSunrateTradePriceService apiSunrateTradePriceService;
    @Autowired
    private ValidateCodeProcessorHolder validateCodeProcessorHolder;
    @Autowired
    JsKycSunrateBeneficiaryService jsKycSunrateBeneficiaryService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ChinaPNRPayOpenAccountService chinaPNRPayOpenAccountService;

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiKycCertiLinkFileService apiKycCertiLinkFileService;
    @Autowired
    JsKycNaturalService jsKycNaturalService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiJsPaySunrateBankService apiJsPaySunrateBankService;

    @Override
    public ResponseMessage applyWithdraw(ApplyWithdrawTotalReq applyWithdrawTotalReq, KycNaturalVO kycNaturalVO, HttpServletResponse response) {
        log.info("提现入参：{}",applyWithdrawTotalReq);
        ResponseMessage bankCardResponse = apiKycBankService.getBankCard(applyWithdrawTotalReq.getBankId());
        log.info("根据提现入参查询银行卡信息：{}",JSON.toJSONString(bankCardResponse));
        if(!bankCardResponse.isSuccess()){
            return bankCardResponse;
        }
        KycBankVO kycBankVO = (KycBankVO)bankCardResponse.getData();
        if(null == kycBankVO){
            log.error("根据提现入参查询银行卡信息不存在");
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        if(!applyWithdrawTotalReq.getAccountNo().equals(kycBankVO.getAccountNo())
            || !applyWithdrawTotalReq.getPhone().equals(kycBankVO.getPhone())){
            log.error("提现入参输入银行账号或者手机号不符合");
            return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR);
        }
        BigDecimal countBigDecimal = new BigDecimal(0);
        List<ApplyWithdrawReq> withdrawStoreList = applyWithdrawTotalReq.getWithdrawStoreList();
        for(ApplyWithdrawReq applyWithdrawReq : withdrawStoreList){
            countBigDecimal = countBigDecimal.add(applyWithdrawReq.getWithdrawAmt());
        }
        log.info("提现总金额：{}，店铺加和：{}",applyWithdrawTotalReq.getWithdrawTotalAmt(),countBigDecimal);
        if(countBigDecimal.compareTo(applyWithdrawTotalReq.getWithdrawTotalAmt()) != 0){
            log.error("提现总金额与店铺提现金额加和不符合");
            return ResultUtil.error(ResultEnum.ERROR);
        }
        //校验验证码是否正确
        try {
            ValidateCodeReq validateCodeReq = regiserReqConvertToValidateCodeReq(applyWithdrawTotalReq);
            validateCodeProcessorHolder.findValidateCodeProcessor("sms").validate(validateCodeReq, response);
        } catch (ValidateCodeException exception) {
            return ResultUtil.error(ResultEnum.VALIDATE_CODE_ERROT.getCode(),exception.getMessage());
        } catch (Exception e) {
            return ResultUtil.error(ResultEnum.VALIDATE_CODE_ERROT.getCode(),ResultEnum.VALIDATE_CODE_ERROT.getMsg());
        }
        for(ApplyWithdrawReq applyWithdrawReq : withdrawStoreList){
            ResponseMessage responseMessage = apiJsPaySunrateBankService.applyWithdraw(applyWithdrawReq, kycNaturalVO,kycBankVO);
            log.info("单个店铺申请提现结果：{}",JSON.toJSONString(responseMessage));
        }
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    private ValidateCodeReq regiserReqConvertToValidateCodeReq(ApplyWithdrawTotalReq applyWithdrawTotalReq){
        ValidateCodeReq validateCodeReq = new ValidateCodeReq();
        validateCodeReq.setMarkStr(applyWithdrawTotalReq.getMarkStr());
        validateCodeReq.setPhoneNo(applyWithdrawTotalReq.getPhone());
        validateCodeReq.setSmsCode(applyWithdrawTotalReq.getSmsCode());
        return validateCodeReq;
    }
}
