package com.js.web.service.impl;

import com.js.api.jsloan.service.ApiJsLoanApplicationService;
import com.js.common.constant.Constant;
import com.js.common.model.req.JsLoanApplyInfoReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsLoanApplicationService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.stereotype.Service;

/**
 * @Description: 贷款申请
 * @Author: zhouyongsheng
 * @Create: 2019-05-21
 **/
@Slf4j
@Service
public class JsLoanApplicationServiceImpl implements JsLoanApplicationService {

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiJsLoanApplicationService apiJsLoanApplicationService;

    @Override
    public ResponseMessage loanApply(JsLoanApplyInfoReq req) {
        return apiJsLoanApplicationService.loanApply(req);
    }
}
