package com.js.web.service.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.js.api.jspay.service.*;
import com.js.api.jspay.service.chinapnr.ChinaPNRPayOpenAccountService;
import com.js.api.jspay.service.chinapnr.ChinaPNRPaySubstituteService;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.ProcessStatusEnum;
import com.js.common.enums.ResultEnum;
import com.js.common.enums.SysPlateformType;
import com.js.common.enums.TradeSubTypeEnum;
import com.js.common.model.req.*;
import com.js.common.model.vo.*;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.web.service.JsKycSunrateService;
import com.js.web.service.SunrateTradePriceService;
import com.js.web.utils.ValidatorUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

/**
 * @Description: 寻汇虚拟银行账户服务实现
 * @Author: liuh
 * @Create: 2019-05-21
 **/
@Slf4j
@Service
public class JsKycSunrateServiceImpl implements JsKycSunrateService {
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiJsPaySunrateBankTradeInService apiJsPaySunrateBankTradeInService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiSunrateRegisterService apiSunrateRegisterService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiJsPaySunrateBankService apiJsPaySunrateBankService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiKycSunrateStoreService apiKycSunrateStoreService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiSunrateBeneficiaryService apiSunrateBeneficiaryService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiJsPaySunrateTradeLockPriceService apiJsPaySunrateTradeLockPriceService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiJsPaySunrateBankTradeOutService apiJsPaySunrateBankTradeOutService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiJsLoanApplyInfoService apiJsLoanApplyInfoService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiKycBankService apiKycBankService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiJsKycChargeService apiJsKycChargeService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ChinaPNRPayOpenAccountService chinaPNRPayOpenAccountService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ChinaPNRPaySubstituteService chinaPNRPaySubstituteService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiJsPaySysAcctService apiJsPaySysAcctService;
    @Autowired
    SunrateTradePriceService sunrateTradePriceService;

    @Override
    public ResponseMessage virtualNotice(JsPaySunrateBankReq jsPaySunrateBankReq){
        log.info("寻汇虚拟子账户通知开始:{}", JSON.toJSONString(jsPaySunrateBankReq));
        ValidatorUtil.paramsValid(jsPaySunrateBankReq);
        ResponseMessage responseMessage = apiJsPaySunrateBankService.virtualNotice(jsPaySunrateBankReq);
        log.info("寻汇虚拟子账户通知结束");
        return responseMessage;
    }

    @Override
    public ResponseMessage registerCreateNotice(KycSunrateRegisterNoticeReq kycSunrateRegisterNoticeReq) {
        log.info("寻汇开户结果通知开始:{}", JSON.toJSONString(kycSunrateRegisterNoticeReq));
        ValidatorUtil.paramsValid(kycSunrateRegisterNoticeReq);
        ResponseMessage responseMessage = apiSunrateRegisterService.registerCreateNotice(kycSunrateRegisterNoticeReq);
        log.info("寻汇开户结果通知结束 : {}",responseMessage.isSuccess());
        return responseMessage;
    }

    @Override
    public ResponseMessage bankTradeInNotice(JsPaySunrateBankTradeInReq jsPaySunrateBankTradeInReq) {
        log.info("查询是否有贷款信息-开始:{}", JSON.toJSONString(jsPaySunrateBankTradeInReq));
        ValidatorUtil.paramsValid(jsPaySunrateBankTradeInReq);
        ResponseMessage responseMessageQueryLoanInfo = apiJsLoanApplyInfoService.findLoanApplyInfo(jsPaySunrateBankTradeInReq);
        if(!responseMessageQueryLoanInfo.isSuccess()){
            return responseMessageQueryLoanInfo;
        }
        log.info("查询是否有贷款信息-结束,结果-{}",responseMessageQueryLoanInfo.isSuccess());
        JsLoanApplyInfoVO jsLoanApplyInfoVO = null == responseMessageQueryLoanInfo.getData() ? null : (JsLoanApplyInfoVO) responseMessageQueryLoanInfo.getData() ;
        jsPaySunrateBankTradeInReq.setProcessStatusEnum(null != jsLoanApplyInfoVO ? ProcessStatusEnum.TRADE_UNPROCESSED : ProcessStatusEnum.TRADE_PROCESSED);
        log.info("寻汇入账通知保存交易信息-开始");
        ResponseMessage responseMessage = apiJsPaySunrateBankTradeInService.bankTradeInNotice(jsPaySunrateBankTradeInReq);
        log.info("寻汇入账通知保存交易信息-结束:结果{},提示信息{}",responseMessage.isSuccess(),responseMessage.getMsg());
        if(!responseMessage.isSuccess()){
            return responseMessage;
        }
        boolean isExecuteUpdate = true;
        //默认可操作金额 等于 入账金额
        BigDecimal operateAmt = jsPaySunrateBankTradeInReq.getTransinAmt();

        //当有贷款,且入账金额大于最小外币金额时
        if(null != jsLoanApplyInfoVO && jsPaySunrateBankTradeInReq.getTransinAmt().compareTo(CommonConstant.SURATE_TRADE_MIN_AMT) > -1){
            //入账金额 * 35%为计算
            BigDecimal scaletransinAmt = jsPaySunrateBankTradeInReq.getTransinAmt().multiply(new BigDecimal(0.35)).setScale(2,BigDecimal.ROUND_HALF_UP);
            //当入账金额 * 35% < 最小交易金额时,操作金额赋值为最小交易金额,否则操作金额等于入账 * 35%
            operateAmt = scaletransinAmt.compareTo(CommonConstant.SURATE_TRADE_MIN_AMT) < 0 ? CommonConstant.SURATE_TRADE_MIN_AMT : scaletransinAmt;
            //计算未还贷款总金额
            BigDecimal loanTotalAmt = jsLoanApplyInfoVO.getUnpayFee().add(jsLoanApplyInfoVO.getUnpayInterest()).add(jsLoanApplyInfoVO.getUnpayPenalty())
                    .add(jsLoanApplyInfoVO.getUnpayPrepaymentFee()).add(jsLoanApplyInfoVO.getUnpayPrincipal());
            BigDecimal aboutScale = new BigDecimal(6);
            BigDecimal sellAmt = loanTotalAmt.divide(aboutScale,2,BigDecimal.ROUND_HALF_UP);
            //当剩余贷款总额以大概计算外币小于 35%金额时，反推外币金额
            if(sellAmt.compareTo(operateAmt) < 1){
                //计算从外币转换到人民币时包含手续费的总金额,已及加入扣除汇差的金额  总和
                BigDecimal allTotalCNYAmt = loanTotalAmt.divide(new BigDecimal(1).subtract(CommonConstant.JS_TRADE_SERVICE_CHARGE_VALUE),2,BigDecimal.ROUND_HALF_UP).divide(CommonConstant.JS_TRADE_RATE_VALUE,2,BigDecimal.ROUND_HALF_UP);
                //调用寻汇询价接口，查询 当前计算出的人民币转换到外币的金额
                JsPaySunrateTradeQueryPriceVo jsPaySunrateTradeQueryPriceVo = sunrateTradePriceService.xhQueryPrice(allTotalCNYAmt, jsPaySunrateBankTradeInReq.getTransinCur(), jsPaySunrateBankTradeInReq.getOrgCode());
                sellAmt = jsPaySunrateTradeQueryPriceVo.getSellAmt();
            }
            //当反推待还贷款总外币金额 < 最小交易金额时,操作金额赋值为最小交易金额,和如果符合第一条件，35%金额 > 还贷金额  取还贷金额，否则取 35%金额
            operateAmt = sellAmt.compareTo(CommonConstant.SURATE_TRADE_MIN_AMT) < 0 ? CommonConstant.SURATE_TRADE_MIN_AMT : operateAmt.compareTo(sellAmt) > 0 ? sellAmt : operateAmt;
            jsPaySunrateBankTradeInReq.setTxnAmt(operateAmt);
            //调用询价以及询价锁汇接口
            ResponseMessage tradeMarketOrderResponse = apiJsPaySunrateTradeLockPriceService.queryPriceTradeOrder(jsPaySunrateBankTradeInReq);
            if(tradeMarketOrderResponse.isSuccess()){
                jsPaySunrateBankTradeInReq.setUpdateTradeInFlag(true);
                jsPaySunrateBankTradeInReq.setProcessStatusEnum(ProcessStatusEnum.TRADE_PROCESSED);
            }else{
                isExecuteUpdate = false;
            }
        }else{
            jsPaySunrateBankTradeInReq.setUpdateTradeInFlag(true);
        }
        if(isExecuteUpdate){
            log.info("更新账户余额开始");
            jsPaySunrateBankTradeInReq.setTxnAmt(operateAmt);
            ResponseMessage updateVirtualAmtResponse = apiJsPaySunrateBankService.updateVirtualAmt(jsPaySunrateBankTradeInReq);
            log.info("更新账户余额结束：返回结果：{},信息{}",updateVirtualAmtResponse.getCode(),updateVirtualAmtResponse.getMsg());
        }
        return responseMessage;
    }

    @Override
    public ResponseMessage storeAuditNotice(SunrateStoreAuditReq sunrateStoreAuditReq) {
        ValidatorUtil.paramsValid(sunrateStoreAuditReq);
        log.info("寻汇店铺审核通知操作开始:{}", JSON.toJSONString(sunrateStoreAuditReq));
        ResponseMessage responseMessage = apiKycSunrateStoreService.storeAuditNotice(sunrateStoreAuditReq);
        log.info("寻汇店铺审核通知操作结束：{}",responseMessage.isSuccess());
        return responseMessage;
    }

    @Override
    public ResponseMessage beneficiayAuditNotice(SunrateBeneficiaryAuditReq sunrateBeneficiaryAuditReq) {
        log.info("寻汇受益人审核通知操作开始:{}", JSON.toJSONString(sunrateBeneficiaryAuditReq));
        ValidatorUtil.paramsValid(sunrateBeneficiaryAuditReq);
        ResponseMessage responseMessage = apiSunrateBeneficiaryService.beneficiayAuditNotice(sunrateBeneficiaryAuditReq);
        log.info("寻汇受益人审核通知操作结束：{}",responseMessage.isSuccess());
        return responseMessage;
    }

    @Override
    public ResponseMessage bankTradeOutNotice(JsPaySunrateBankTradeOutReq jsPaySunrateBankTradeOutReq) {
        log.info("寻汇出账通知保存交易信息-开始:{}",JSON.toJSONString(jsPaySunrateBankTradeOutReq));
        ValidatorUtil.paramsValid(jsPaySunrateBankTradeOutReq);
        JsPaySunrateTradeLockPriceVO jsPaySunrateTradeLockPriceVO = apiJsPaySunrateTradeLockPriceService.findTradeLockInfo(jsPaySunrateBankTradeOutReq);
        if(null == jsPaySunrateTradeLockPriceVO){
            log.error("未查询到锁汇交易信息");
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        log.info("查询到提交锁汇交易信息:{}",JSON.toJSONString(jsPaySunrateTradeLockPriceVO));
        jsPaySunrateBankTradeOutReq.setProcessStatusEnum(ProcessStatusEnum.TRADE_UNPROCESSED);
        ResponseMessage responseMessage = apiJsPaySunrateBankTradeOutService.bankTradeOutNotice(jsPaySunrateBankTradeOutReq,jsPaySunrateTradeLockPriceVO);
        log.info("寻汇出账通知保存交易信息-结束:结果{},提示信息{}",responseMessage.isSuccess(),responseMessage.getMsg());
        if(!responseMessage.isSuccess()){
            return responseMessage;
        }

        //锁汇交易类型
        TradeSubTypeEnum tradeType = jsPaySunrateTradeLockPriceVO.getTradeType();
        //当锁汇交易为提现操作时
        if(TradeSubTypeEnum.WITHDRAW.equals(tradeType)){
            ResponseMessage bankCardResponse = apiKycBankService.getBankCard(jsPaySunrateTradeLockPriceVO.getKycBankId());
            if(!bankCardResponse.isSuccess()){
                log.error("为查询到提现银行卡信息：{}",jsPaySunrateTradeLockPriceVO.getKycBankId());
                return responseMessage;
            }
            KycBankVO kycBankVO = (KycBankVO)bankCardResponse.getData();
            //银行卡提现渠道
            SysPlateformType routeType = kycBankVO.getRouteType();
            if(SysPlateformType.HFGJ.equals(routeType)){
                //走汇付国际提现通道
                withdrawByHFGJRouteType(kycBankVO.getKycNaturalId(), jsPaySunrateBankTradeOutReq);
            }else if(SysPlateformType.SUNRATE.equals(routeType)){
                //走寻汇提现通道
                withdrawBySunrateRouteType(kycBankVO.getKycNaturalId(), jsPaySunrateBankTradeOutReq);
            }else{
                log.error("提现渠道不正确：{}",routeType);
                return responseMessage;
            }
        }else{
            log.error("交易类型不正确：{}",tradeType);
            return responseMessage;
        }
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    private ResponseMessage withdrawByHFGJRouteType(String kycNaturalId,JsPaySunrateBankTradeOutReq jsPaySunrateBankTradeOutReq){
        //查询汇差
        JsKycChargeReq jsKycChargeRateReq = new JsKycChargeReq();
        jsKycChargeRateReq.setKycNaturalId(kycNaturalId);
        jsKycChargeRateReq.setChargeType("RATE");
        JsKycChargeVO jsKycChargeRateVO = apiJsKycChargeService.findKycChargeInfo(jsKycChargeRateReq);
        //汇差标准
        BigDecimal rate = null == jsKycChargeRateVO ? CommonConstant.JS_TRADE_RATE_VALUE : jsKycChargeRateVO.getChargeScale();

        //查询手续费
        JsKycChargeReq jsKycChargeReq = new JsKycChargeReq();
        jsKycChargeReq.setKycNaturalId(kycNaturalId);
        jsKycChargeReq.setChargeType("SERVICE_CHARGE");
        JsKycChargeVO jsKycChargeVO = apiJsKycChargeService.findKycChargeInfo(jsKycChargeReq);
        //手续费标准
        BigDecimal serviceCharge = null == jsKycChargeVO ? CommonConstant.JS_TRADE_SERVICE_CHARGE_VALUE : jsKycChargeVO.getChargeScale();

        ResponseMessage responseMessage = chinaPNRPayOpenAccountService.queryOpenAccount(kycNaturalId, "0");
        log.info("查询汇付开户信息返回结果：{}",JSON.toJSONString(responseMessage));
        if(!responseMessage.isSuccess()){
            log.error("未查询到汇付开始信息");
            return responseMessage;
        }
        ChinaPNROpenAccountVO chinaPNROpenAccountVO = (ChinaPNROpenAccountVO)responseMessage.getData();
        //汇差金额
        BigDecimal rateAmt = jsPaySunrateBankTradeOutReq.getPayAmt().multiply(rate).setScale(2,BigDecimal.ROUND_HALF_UP);
        //手续费金额
        BigDecimal serviceChargeAmt = jsPaySunrateBankTradeOutReq.getPayAmt().multiply(serviceCharge).setScale(2,BigDecimal.ROUND_HALF_UP);
        //扣除汇差，手续费后，用户可到账金额
        BigDecimal userAmt = jsPaySunrateBankTradeOutReq.getPayAmt().subtract(rateAmt).subtract(serviceChargeAmt).setScale(2,BigDecimal.ROUND_HALF_UP);

        List<ChinaPNRSubstituteDetails> chinaPNRSubstituteDetailsList = new ArrayList<>();

//        List<JsPaySysAcctVO> jsPaySysAcctList = apiJsPaySysAcctService.findJsPaySysAcctList();

        chinaPNRSubstituteDetailsList.add(convertToChinaPNRSubstituteDetails("汇差户ID","030",rateAmt,chinaPNROpenAccountVO));
        chinaPNRSubstituteDetailsList.add(convertToChinaPNRSubstituteDetails("手续费户ID","050",serviceChargeAmt,chinaPNROpenAccountVO));
        chinaPNRSubstituteDetailsList.add(convertToChinaPNRSubstituteDetails(kycNaturalId,"缺少类型",serviceChargeAmt,chinaPNROpenAccountVO));


        ChinaPNRSubstituteReq chinaPNRSubstituteReq = convertToChinaPNRSubstituteReq(kycNaturalId,chinaPNRSubstituteDetailsList.size(),jsPaySunrateBankTradeOutReq.getPayAmt());
        ResponseMessage oldSubstituteTradeResponse = chinaPNRPaySubstituteService.oldSubstituteTrade(chinaPNRSubstituteReq);
        log.info("发起汇付代发结果：{}",JSON.toJSONString(oldSubstituteTradeResponse));
        if(!oldSubstituteTradeResponse.isSuccess()){
            log.error("发送汇付代发申请失败{}",oldSubstituteTradeResponse.getMsg());
            //TODO  预警
        }
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    private ChinaPNRSubstituteReq convertToChinaPNRSubstituteReq(String kycNaturalId,int count,BigDecimal allTotal){
        ChinaPNRSubstituteReq chinaPNRSubstituteReq = new ChinaPNRSubstituteReq();
        chinaPNRSubstituteReq.setKycNaturalId(kycNaturalId);
        chinaPNRSubstituteReq.setBatchNo(IdUtil.simpleUUID());//批次号
        chinaPNRSubstituteReq.setRequestId(IdUtil.simpleUUID());//请求流水号
        chinaPNRSubstituteReq.setPayTCnt(count);//总笔数
        chinaPNRSubstituteReq.setPayTAmt(allTotal);//总金额
        chinaPNRSubstituteReq.setRemitType("2"); //1：T+0到账  2：T+1到账
        chinaPNRSubstituteReq.setPayCur(CommonConstant.TRADE_CURRENCY_CNY);//交易币种
        return chinaPNRSubstituteReq;
    }

    private ChinaPNRSubstituteDetails convertToChinaPNRSubstituteDetails(String kycNaturalId,String tradeType,BigDecimal detailAmt,ChinaPNROpenAccountVO chinaPNROpenAccountVO){
        ChinaPNRSubstituteDetails chinaPNRSubstituteDetails = new ChinaPNRSubstituteDetails();
        chinaPNRSubstituteDetails.setSubstituteDetailId(IdUtil.simpleUUID());//代发明细流水号
        chinaPNRSubstituteDetails.setSubstituteDetailAmt(detailAmt);//金额
        chinaPNRSubstituteDetails.setAccountNumbe(kycNaturalId);//账号，当为汇付内部户时传用户ID
        chinaPNRSubstituteDetails.setSubstituteType(tradeType);//交易类型-010 贷款服务本金 020 提现服务 030 汇差 040贷款服务费 050 提现服务费 060贷款服务利息
        chinaPNRSubstituteDetails.setDocumentType(chinaPNROpenAccountVO.getCertType());//证件类型 00–身份证
        chinaPNRSubstituteDetails.setIdentificationNumber(chinaPNROpenAccountVO.getCertId());//证件号码
        chinaPNRSubstituteDetails.setPurpose("用途"); // 必填项   TODO
        chinaPNRSubstituteDetails.setPaymentOutName("出款用户号");// TODO
        return chinaPNRSubstituteDetails;
    }

    private ResponseMessage withdrawBySunrateRouteType(String kycNaturalId,JsPaySunrateBankTradeOutReq jsPaySunrateBankTradeOutReq){



        return ResultUtil.success(ResultEnum.SUCCESS);
    }
}
