package com.js.web.service.impl;

import com.js.api.jspay.service.*;
import com.js.common.constant.Constant;
import com.js.common.enums.BeneficiaryTypeEnum;
import com.js.common.model.req.*;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.KycSunrateBeneficiaryVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsKycSunrateBeneficiaryService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Description: 与寻汇交互受益人操作相关服务实现
 * @Author: liuh
 * @Create: 2019-06-20
 **/
@Slf4j
@Service
public class JsKycSunrateBeneficiaryServiceImpl implements JsKycSunrateBeneficiaryService {
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0
    )
    private ApiSunrateBeneficiaryService apiSunrateBeneficiaryService;

    @Override
    public ResponseMessage beneficiaryCreate(KycSunrateBeneficiaryReq kycSunrateBeneficiaryReq, KycNaturalVO kycNaturalVO) {
        return apiSunrateBeneficiaryService.beneficiaryCreate(kycSunrateBeneficiaryReq,kycNaturalVO);
    }

    @Override
    public ResponseMessage beneficiaryCreate(String orgCode,String browserIP, KycNaturalVO kycNaturalVO) {
        return apiSunrateBeneficiaryService.beneficiaryCreate(orgCode,browserIP,kycNaturalVO);
    }

    @Override
    public List<KycSunrateBeneficiaryVO> beneficiaryListByOrgCode(String orgCode, BeneficiaryTypeEnum beneficiaryTypeEnum) {
        return apiSunrateBeneficiaryService.beneficiaryListByOrgCode(orgCode,beneficiaryTypeEnum);
    }
}
