package com.js.web.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.js.api.jspay.service.*;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.CertiStatusEnum;
import com.js.common.enums.ResultEnum;
import com.js.common.enums.SiteEnum;
import com.js.common.model.req.*;
import com.js.common.model.vo.*;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.api.sync.service.CheckAuthTokenService;
import com.js.web.service.JsKycStoreService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.stereotype.Service;

import java.text.DecimalFormat;
import java.util.*;

/**
 * @Description: 申请虚拟账户-添加店铺服务实现
 * @Author: liuh
 * @Create: 2019-05-21
 **/
@Slf4j
@Service
public class JsKycStoreServiceImpl implements JsKycStoreService {

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiKycStoreService apiKycStoreService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiSunrateTradePriceService apiSunrateTradePriceService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiKycSunrateStoreService apiKycSunrateStoreService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiJsPaySunrateBankService apiJsPaySunrateBankService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiJsKycChargeService apiJsKycChargeService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiKycBankService apiKycBankService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private CheckAuthTokenService checkAuthTokenService;

    @Override
    public ResponseMessage addStore(KycStoreReq kycStoreReq, KycNaturalVO kycNaturalVO) {
        if(kycStoreReq.getStoreSituation() && (StringUtils.isBlank(kycStoreReq.getSellId()) || StringUtils.isBlank(kycStoreReq.getMwsAuthToken()))){
            return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() + ",已有店铺时,请填写卖家编号和token");
        }
        if(kycStoreReq.getStoreSituation()){
            //TODO 调用接口查看token是否可用，来更新授权状态
            //条用未通过标识授权不成功，则返回错误信息
        }
        //未实名认证通过不可申请虚拟账号绑定店铺
        log.info("当前实名状态:{}",kycNaturalVO.getCertificationStatus());
        if(CertiStatusEnum.FAILURE.equals(kycNaturalVO.getCertificationStatus())){
            return ResultUtil.error(ResultEnum.CERTI_FAILURE.getCode(),ResultEnum.CERTI_FAILURE.getMsg());
        }else if(CertiStatusEnum.NO_SUBMIT.equals(kycNaturalVO.getCertificationStatus())
            || CertiStatusEnum.SUBMIT_FAILURE.equals(kycNaturalVO.getCertificationStatus())
            || CertiStatusEnum.SUBMIT_WATING.equals(kycNaturalVO.getCertificationStatus())){
            return ResultUtil.error(ResultEnum.CERTI_WATRING.getCode(),ResultEnum.CERTI_WATRING.getMsg());
        }
        ResponseMessage addStoreResponseMessage = apiKycStoreService.addStore(kycStoreReq, kycNaturalVO);
        if(!addStoreResponseMessage.isSuccess()){
            return addStoreResponseMessage;
        }
        String kycStoreId = addStoreResponseMessage.getData().toString();
        log.info("请求寻汇公共方法添加店铺信息-开始");
        KycSunrateStoreReq kycSunrateStoreReq = ConvertToKycSunrateStoreReq(kycStoreReq,kycNaturalVO);
        ResponseMessage responseMessage = apiKycSunrateStoreService.sendSunrateStoreInfoToXh(kycStoreReq.getBrowserIP(), kycSunrateStoreReq);
        log.info("请求寻汇公共方法添加店铺信息-结束，请求结果：{}，返回信息:{}",responseMessage.isSuccess(),responseMessage.getMsg());
        if(!responseMessage.isSuccess()){
            return addStoreResponseMessage;
        }
        JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(responseMessage.getData()));
        String subAcctNo = jsonObject.getString("subAcctNo");
        kycSunrateStoreReq.setKycStoreId(kycStoreId);
        kycSunrateStoreReq.setSubAcctNo(subAcctNo);
        log.info("保存请求寻汇添加店铺信息-开始");
        ResponseMessage responseMessage1 = apiKycSunrateStoreService.addSunrateStore(kycSunrateStoreReq, kycNaturalVO);
        log.info("保存请求寻汇添加店铺信息-结束，请求结果：{}，返回信息:{}",responseMessage1.isSuccess(),responseMessage1.getMsg());
        return addStoreResponseMessage;
    }

    private KycSunrateStoreReq ConvertToKycSunrateStoreReq(KycStoreReq kycStoreReq, KycNaturalVO kycNaturalVO){
        String orgCode = apiSunrateTradePriceService.findOrgCode(kycNaturalVO.getId(),kycNaturalVO.getRegisterType());
        KycSunrateStoreReq kycSunrateStoreReq = new KycSunrateStoreReq();
        kycSunrateStoreReq.setOrgCode(orgCode);
        kycSunrateStoreReq.setCurId(kycStoreReq.getStoreTheSite().getCurrency());
        kycSunrateStoreReq.setStoreName(kycStoreReq.getStoreName());
        kycSunrateStoreReq.setStoreUrl(kycStoreReq.getStoreUrl());
        kycSunrateStoreReq.setStorePlateform(kycStoreReq.getStorePlateform().getCode());
        if(StringUtils.isNotBlank(kycStoreReq.getSellId())){
            kycSunrateStoreReq.setSellerId(kycStoreReq.getSellId());
        }
//        kycSunrateStoreReq.setAccessKey(kycStoreReq.getMwsAuthToken());
        return kycSunrateStoreReq;
    }

    @Override
    public ResponseMessage storeList(KycShowStoreReq kycShowStoreReq, KycNaturalVO kycNaturalVO) {
        return apiKycStoreService.storeList(kycShowStoreReq,kycNaturalVO);
    }

    @Override
    public ResponseMessage findApplyCountNum(String browserIP,KycNaturalVO kycNaturalVO) {
        return apiKycStoreService.findApplyCountNum(browserIP,kycNaturalVO);
    }

    @Override
    public ResponseMessage findStoreDetailInfo(String kycStoreId, KycNaturalVO kycNaturalVO) {
        log.info("查询店铺信息:{}",kycStoreId);
        KycStoreVO kycStoreVO = apiKycStoreService.findKycStoreByPrimaryKey(kycStoreId, kycNaturalVO);
        if(null == kycStoreVO){
            log.error("未查询到店铺信息");
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        log.info("查询到店铺信息:{}",JSON.toJSONString(kycStoreVO));
        Map<String,Object> resultMap = new HashMap<>();
        resultMap.put("storeInfo",kycStoreVO);
        KycSunrateStoreVO kycSunrateStoreVO = apiKycSunrateStoreService.findSunrateStoreInfo(kycStoreVO.getStoreId(), kycNaturalVO);
        if(null == kycSunrateStoreVO){
            log.info("未查询到-寻汇-店铺信息");
            return ResultUtil.success(resultMap);
        }
        JsPaySunrateBankReq jsPaySunrateBankReq = new JsPaySunrateBankReq();
        jsPaySunrateBankReq.setOrgCode(kycSunrateStoreVO.getOrgCode());
        jsPaySunrateBankReq.setSubAcctNo(kycSunrateStoreVO.getSubAcctNo());
        JsPaySunrateBankVO jsPaySunrateBankVO = apiJsPaySunrateBankService.findSunrateBankInfo(jsPaySunrateBankReq, kycNaturalVO);
        if(null == jsPaySunrateBankVO){
            log.info("未查询到虚拟账户信息");
            return ResultUtil.success(resultMap);
        }
        SiteEnum siteEnum = SiteEnum.getByCurrency(jsPaySunrateBankVO.getCurId());
        jsPaySunrateBankVO.setCurIdSymbol(null == siteEnum ? "" : siteEnum.getCurrencySymbol());
        resultMap.put("accountInfo",jsPaySunrateBankVO);
        return ResultUtil.success(resultMap);
    }

    @Override
    public ResponseMessage editStore(KycStoreEditReq kycStoreEditReq, KycNaturalVO kycNaturalVO) {
        //TODO 调用接口查看token是否可用，来更新授权状态
        //条用未通过标识授权不成功，则返回错误信息
        return apiKycStoreService.editStore(kycStoreEditReq,kycNaturalVO);
    }

    @Override
    public ResponseMessage findCanWithdrawStoreList(SiteEnum siteEnum, KycNaturalVO kycNaturalVO) {
        ResponseMessage responseMessage = apiJsPaySunrateBankService.selCanWithdrawAcctList(siteEnum,kycNaturalVO);
        return responseMessage;
    }

    @Override
    public ResponseMessage initWithdrawInfo(KycNaturalVO kycNaturalVO) {
        JSONObject jsonObject = new JSONObject();
        JsKycChargeReq jsKycChargeReq = new JsKycChargeReq();
        jsKycChargeReq.setKycNaturalId(kycNaturalVO.getId());
        jsKycChargeReq.setChargeType("SERVICE_CHARGE");
        JsKycChargeVO jsKycChargeVO = apiJsKycChargeService.findKycChargeInfo(jsKycChargeReq);
        DecimalFormat df = new DecimalFormat("0.00%");
        //显示手续费
        jsonObject.put("serviceCharge",null == jsKycChargeVO ? df.format(CommonConstant.JS_TRADE_SERVICE_CHARGE_VALUE) : df.format(jsKycChargeVO.getChargeScale()));
        KycBankCardReq kycBankCardReq = new KycBankCardReq();
        kycBankCardReq.setKycNaturalId(kycNaturalVO.getId());
        ResponseMessage bankListResponse = apiKycBankService.getKycBankList(kycBankCardReq);
        Set<String> set = new HashSet<>();
        if(bankListResponse.isSuccess()){
            JSONArray jsonArray = JSONArray.parseArray(JSON.toJSONString(bankListResponse.getData()));
            for(int i = 0 ; i < jsonArray.size(); i ++){
                JSONObject jsonObject1 = jsonArray.getJSONObject(i);
                set.add(jsonObject1.getString("currencyCode"));
            }
        }
        List<Map<String,Object>> currencyList = new ArrayList<>();//银行卡可用币种集合
        for(String currencyCode : set){
            if(CommonConstant.TRADE_CURRENCY_CNY.equals(currencyCode)){
                Map<String,Object> currencyMap = new HashMap<>();
                currencyMap.put("currencyKyc",CommonConstant.TRADE_CURRENCY_CNY);
                currencyMap.put("currency",CommonConstant.TRADE_CURRENCY_CNY + "/人民币");
                currencyList.add(currencyMap);
            }else{
                SiteEnum siteEnum = SiteEnum.getByCurrency(currencyCode);
                if(null == siteEnum){
                    Map<String,Object> currencyMap = new HashMap<>();
                    currencyMap.put("currencyKyc","");
                    currencyMap.put("currency",currencyCode);
                    currencyList.add(currencyMap);
                }else{
                    Map<String,Object> currencyMap = new HashMap<>();
                    currencyMap.put("currencyKyc",siteEnum.getCurrency());
                    currencyMap.put("currency",siteEnum.getCurrency() + "/" + siteEnum.getHyDesc());
                    currencyList.add(currencyMap);
                }
            }
        }
        jsonObject.put("currencyList",currencyList);
        return ResultUtil.success(jsonObject);
    }

    @Override
    public ResponseMessage checkStoreToken(KycStoreCheckTokenReq kycStoreCheckTokenReq) {
        return checkAuthTokenService.checkToken(kycStoreCheckTokenReq);
    }
}
