package com.js.web.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.js.api.jspay.service.ApiKycCertiMainLandPersonalService;
import com.js.api.jspay.service.ApiKycSunrateService;
import com.js.api.jspay.service.ApiSunrateRegisterService;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.CertiMainLandPersonalReq;
import com.js.common.model.req.ChinaPNRPersonalOpenAccountReq;
import com.js.common.model.req.KycCertiLinkFileReq;
import com.js.common.model.req.KycSunrateRegisterReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.web.service.JsKycCertiMainLandPersonalService;
import com.js.web.service.JsKycSunrateBeneficiaryService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Description: 大陆个人操作服务实现
 * @Author: liuh
 * @Create: 2019-05-18
 **/
@Slf4j
@Service
public class JsKycCertiMainLandPersonalServiceImpl implements JsKycCertiMainLandPersonalService {
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiKycCertiMainLandPersonalService  apiKycCertiMainLandPersonalService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiKycSunrateService apiKycSunrateService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiSunrateRegisterService apiSunrateRegisterService;
    @Autowired
    JsKycSunrateBeneficiaryService jsKycSunrateBeneficiaryService;

    @Override
    public ResponseMessage certiMainLandPersonalAdd(CertiMainLandPersonalReq certiMainLandPersonalReq, KycNaturalVO kycNaturalVO) {
        log.info("大陆个人实名入参：{}", JSON.toJSONString(certiMainLandPersonalReq));
        boolean existsFlag = apiKycCertiMainLandPersonalService.verifyCertiMainLandPersonExists(certiMainLandPersonalReq.getIdNo());
        if(existsFlag){
            return ResultUtil.error(ResultEnum.MESSAGE_EXIST.getCode(), ResultEnum.MESSAGE_EXIST.getMsg());
        }
        boolean longFlag = certiMainLandPersonalReq.getLongFlag();
        //非长期有效且未填写有效直接日期返回错误信息
        if(!longFlag && (null == certiMainLandPersonalReq.getEffectiveEndTime()
            || certiMainLandPersonalReq.getEffectiveEndTime().getTime() < certiMainLandPersonalReq.getEffectiveStartTime().getTime())){
           return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(), ResultEnum.NO_MUST_PARAM_ERROR.getMsg());
        }else{
            certiMainLandPersonalReq.setEffectiveEndTime(CommonConstant.longFormatDate());
        }
        log.info("保存大陆个人-实名信息-开始");
        ResponseMessage addPersonResponseMessage = apiKycCertiMainLandPersonalService.certiMainLandPersonalAdd(certiMainLandPersonalReq,kycNaturalVO);
        log.info("保存大陆个人-实名信息-结束返回结果:{},描述信息:{}",addPersonResponseMessage.isSuccess(),addPersonResponseMessage.getMsg());
        if(!addPersonResponseMessage.isSuccess()){
            return addPersonResponseMessage;
        }
        log.info("大陆个人上传附件到寻汇-开始");
        String priId = addPersonResponseMessage.getData().toString();
        ResponseMessage uploadFileToXhResponseMessage = apiKycSunrateService.uploadFileToXH(priId);
        log.info("大陆个人上传附件到寻汇-结束结束-返回结果:{},描述信息:{}",uploadFileToXhResponseMessage.isSuccess(),uploadFileToXhResponseMessage.getMsg());
        if(!uploadFileToXhResponseMessage.isSuccess()){
            return addPersonResponseMessage;
        }
        log.info("大陆个人调用寻汇公共请求接口-开始");
        String uploadRemotePath = uploadFileToXhResponseMessage.getData().toString();
        KycSunrateRegisterReq kycSunrateRegisterReq = convertToKycSunrateRegisterReq(certiMainLandPersonalReq, kycNaturalVO);
        kycSunrateRegisterReq.setDirPath(uploadRemotePath);
        ResponseMessage sendInfoToXhResponseMessage = apiSunrateRegisterService.sendRegisterInfoToXh(certiMainLandPersonalReq.getBrowserIP(),priId,kycSunrateRegisterReq,kycNaturalVO);
        log.info("大陆个人调用寻汇公共请求接口-结束-返回结果:{},描述信息:{}",sendInfoToXhResponseMessage.isSuccess(),sendInfoToXhResponseMessage.getMsg());

        log.info("大陆个人调用寻汇添加受益人请求接口-开始");
        kycSunrateRegisterReq.setDirPath(uploadRemotePath);
        ResponseMessage beneficiaryResponse = jsKycSunrateBeneficiaryService.beneficiaryCreate(certiMainLandPersonalReq.getIdNo(),certiMainLandPersonalReq.getBrowserIP(),kycNaturalVO);
        log.info("大陆个人调用寻汇添加受益人请求接口-结束-返回结果:{},描述信息:{}",beneficiaryResponse.isSuccess(),beneficiaryResponse.getMsg());
        return ResultUtil.success(ResultEnum.SUCCESS.getCode(), ResultEnum.SUCCESS.getMsg());
    }

    private KycSunrateRegisterReq convertToKycSunrateRegisterReq(CertiMainLandPersonalReq certiMainLandPersonalReq, KycNaturalVO kycNaturalVO){
        KycSunrateRegisterReq kycSunrateRegisterReq = new KycSunrateRegisterReq();
        kycSunrateRegisterReq.setRegisterName(certiMainLandPersonalReq.getCusName());
        kycSunrateRegisterReq.setRegisterEmail(kycNaturalVO.getEmail());
        kycSunrateRegisterReq.setRegisterMobile(kycNaturalVO.getPhoneNo());
        kycSunrateRegisterReq.setRegisterType(1);
        kycSunrateRegisterReq.setName(certiMainLandPersonalReq.getCusName());
        kycSunrateRegisterReq.setOrgCode(certiMainLandPersonalReq.getIdNo());
        kycSunrateRegisterReq.setIdentityType(1);// 1-法定代表人
        kycSunrateRegisterReq.setOpenAddress(certiMainLandPersonalReq.getLiveAddress());
        List<String> fileIdList = new ArrayList<>();
        for(KycCertiLinkFileReq kycCertiLinkFileReq : certiMainLandPersonalReq.getKycCertiLinkFileReqList()){
            fileIdList.add(kycCertiLinkFileReq.getFileSaveName());
        }
        kycSunrateRegisterReq.setFileIdList(fileIdList);
        kycSunrateRegisterReq.setRemark("大陆个人-注册");
        return kycSunrateRegisterReq;
    }

    private ChinaPNRPersonalOpenAccountReq convertToChinaPNRPersonalOpenAccountReq(CertiMainLandPersonalReq certiMainLandPersonalReq, KycNaturalVO kycNaturalVO){
        ChinaPNRPersonalOpenAccountReq chinaPNRPersonalOpenAccountReq = new ChinaPNRPersonalOpenAccountReq();
        chinaPNRPersonalOpenAccountReq.setKycNaturalId(kycNaturalVO.getId());//用户ID
        chinaPNRPersonalOpenAccountReq.setRequestId(IdUtil.simpleUUID());//请求流水号32位
        chinaPNRPersonalOpenAccountReq.setPlatformRegTime(DateUtil.formatDateTime(new Date()));//用户注册时间20190614155601
        chinaPNRPersonalOpenAccountReq.setName(certiMainLandPersonalReq.getCusName());//姓名


//        /**
//         * 00－身份证（目前仅支持00）
//         * 01－护照
//         * 02－军官证
//         * 03－士兵证
//         * 04－回乡证
//         * 06－警官证
//         * 08－台胞证
//         * 13－其他
//         */
//        private String  certType;
//        /**
//         * 号码
//         */
//        private String  certId;
//        /**
//         * 证件失效日期
//         */
//        private String  certExpDateEnd;
//        /**
//         * 手机号码
//         */
//        private String  mobileNumber;
//        /**
//         * 地址
//         */
//        private String  address;
//        /**
//         * 邮件
//         */
//        private String  email;
//        /**
//         * 银行编码
//         */
//        private String  bankCode;
//        /**
//         * 账户号
//         */
//        private String bankAcct;
//        /**
//         * 账户名称
//         */
//        private String  acctName;
//        /**
//         * 证件影印件正面地址
//         */
//        private String  certPhotoCopyF;
//        /**
//         * 证件影印件反面地址
//         */
//        private String  certPhotoCopyB;

        return chinaPNRPersonalOpenAccountReq;
    }
}
