package com.js.web.service.impl;

import com.alibaba.fastjson.JSON;
import com.js.api.jspay.service.ApiKycCertiMainLandCompanyService;
import com.js.api.jspay.service.ApiKycSunrateService;
import com.js.api.jspay.service.ApiSunrateRegisterService;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.CertiMainLandCompanyReq;
import com.js.common.model.req.KycCertiLinkFileReq;
import com.js.common.model.req.KycSunrateRegisterReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.web.service.JsKycCertiMainLandCompanyService;
import com.js.web.service.JsKycSunrateBeneficiaryService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description: 大陆企業操作服务实现
 * @Author: liuh
 * @Create: 2019-05-18
 **/
@Slf4j
@Service
public class JsKycCertiMainLandCompanyServiceImpl implements JsKycCertiMainLandCompanyService {
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiKycCertiMainLandCompanyService apiKycCertiMainLandCompanyService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiKycSunrateService apiKycSunrateService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiSunrateRegisterService apiSunrateRegisterService;
    @Autowired
    JsKycSunrateBeneficiaryService jsKycSunrateBeneficiaryService;

    @Override
    public ResponseMessage certiMainLandCompanyAdd(CertiMainLandCompanyReq certiMainLandCompanyReq, KycNaturalVO kycNaturalVO) {
        log.info("大陆企业实名入参：{}", JSON.toJSONString(certiMainLandCompanyReq));
        boolean existsFlag = apiKycCertiMainLandCompanyService.verifyCertiMainLandComapnyExists(certiMainLandCompanyReq.getUnifiedSocialCreditCode());
        if(existsFlag){
            return ResultUtil.error(ResultEnum.MESSAGE_EXIST.getCode(), ResultEnum.MESSAGE_EXIST.getMsg());
        }
        boolean longFlag = certiMainLandCompanyReq.getLongFlag();
        if(!longFlag && (null == certiMainLandCompanyReq.getEffectiveEndTime()
            || certiMainLandCompanyReq.getEffectiveEndTime().getTime() < certiMainLandCompanyReq.getEffectiveStartTime().getTime())){
            return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(), ResultEnum.NO_MUST_PARAM_ERROR.getMsg());
        }else{
            certiMainLandCompanyReq.setEffectiveEndTime(CommonConstant.longFormatDate());
        }
        log.info("保存大陆企业-实名信息-开始");
        ResponseMessage addCompanyResponseMessage = apiKycCertiMainLandCompanyService.certiMainLandCompanyAdd(certiMainLandCompanyReq,kycNaturalVO);
        log.info("保存大陆企业-实名信息-结束返回结果:{},描述信息:{}",addCompanyResponseMessage.isSuccess(),addCompanyResponseMessage.getMsg());
        if(!addCompanyResponseMessage.isSuccess()){
            return addCompanyResponseMessage;
        }
        log.info("大陆企业上传附件到寻汇-开始");
        String priId = addCompanyResponseMessage.getData().toString();
        ResponseMessage uploadFileToXhResponseMessage = apiKycSunrateService.uploadFileToXH(priId);
        log.info("大陆企业上传附件到寻汇-结束结束-返回结果:{},描述信息:{}",uploadFileToXhResponseMessage.isSuccess(),uploadFileToXhResponseMessage.getMsg());
        if(!uploadFileToXhResponseMessage.isSuccess()){
            return addCompanyResponseMessage;
        }
        log.info("注册大陆企业调用寻汇公共请求接口-开始");
        String uploadRemotePath = uploadFileToXhResponseMessage.getData().toString();
        KycSunrateRegisterReq kycSunrateRegisterReq = ConvertToKycSunrateRegisterReq(certiMainLandCompanyReq, kycNaturalVO);
        kycSunrateRegisterReq.setDirPath(uploadRemotePath);
        ResponseMessage sendInfoToXhResponseMessage = apiSunrateRegisterService.sendRegisterInfoToXh(certiMainLandCompanyReq.getBrowserIP(),priId,kycSunrateRegisterReq,kycNaturalVO);
        log.info("注册企业调用寻汇公共请求接口-结束-返回结果:{},描述信息:{}",sendInfoToXhResponseMessage.isSuccess(),sendInfoToXhResponseMessage.getMsg());
        if(!sendInfoToXhResponseMessage.isSuccess()){
            return addCompanyResponseMessage;
        }
        log.info("大陆企业调用寻汇添加受益人请求接口-开始");
        kycSunrateRegisterReq.setDirPath(uploadRemotePath);
        ResponseMessage beneficiaryResponse = jsKycSunrateBeneficiaryService.beneficiaryCreate(certiMainLandCompanyReq.getUnifiedSocialCreditCode(),certiMainLandCompanyReq.getBrowserIP(),kycNaturalVO);
        log.info("大陆企业调用寻汇添加受益人请求接口-结束-返回结果:{},描述信息:{}",beneficiaryResponse.isSuccess(),beneficiaryResponse.getMsg());
        return ResultUtil.success(ResultEnum.SUCCESS.getCode(), ResultEnum.SUCCESS.getMsg());
    }

    private KycSunrateRegisterReq ConvertToKycSunrateRegisterReq(CertiMainLandCompanyReq certiMainLandCompanyReq, KycNaturalVO kycNaturalVO){
        KycSunrateRegisterReq kycSunrateRegisterReq = new KycSunrateRegisterReq();
        kycSunrateRegisterReq.setRegisterName(certiMainLandCompanyReq.getCompanyName());
        kycSunrateRegisterReq.setRegisterEmail(kycNaturalVO.getEmail());
        kycSunrateRegisterReq.setRegisterMobile(kycNaturalVO.getPhoneNo());
        kycSunrateRegisterReq.setRegisterType(1);
        kycSunrateRegisterReq.setName(certiMainLandCompanyReq.getLegalRepresentativeName());
        kycSunrateRegisterReq.setOrgCode(certiMainLandCompanyReq.getUnifiedSocialCreditCode());
        kycSunrateRegisterReq.setIdentityType(1);// 1-法定代表人
        kycSunrateRegisterReq.setOpenAddress(certiMainLandCompanyReq.getLegalRepresentativeAddress());
        List<String> fileIdList = new ArrayList<>();
        for(KycCertiLinkFileReq kycCertiLinkFileReq : certiMainLandCompanyReq.getKycCertiLinkFileReqList()){
            fileIdList.add(kycCertiLinkFileReq.getFileSaveName());
        }
        kycSunrateRegisterReq.setFileIdList(fileIdList);
        kycSunrateRegisterReq.setRemark("大陆企业-注册");
        return kycSunrateRegisterReq;
    }
}
