package com.js.web.service.impl;

import com.alibaba.fastjson.JSON;
import com.js.api.jspay.service.*;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.*;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.web.service.JsKycCertiHKPersonalService;
import com.js.web.service.JsKycSunrateBeneficiaryService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description: 香港个人操作服务实现
 * @Author: liuh
 * @Create: 2019-05-31
 **/
@Slf4j
@Service
public class JsKycCertiHKPersonalServiceImpl implements JsKycCertiHKPersonalService {
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiKycCertiHKPersonalService apiKycCertiHKPersonalService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiKycSunrateService apiKycSunrateService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiSunrateRegisterService apiSunrateRegisterService;
    @Autowired
    JsKycSunrateBeneficiaryService jsKycSunrateBeneficiaryService;

    @Override
    public ResponseMessage certiHKPersonalAdd(KycCertiHKPersonalReq kycCertiHKPersonalReq, KycNaturalVO kycNaturalVO) {
        log.info("香港个人实名入参：{}", JSON.toJSONString(kycCertiHKPersonalReq));
        boolean existsFlag = apiKycCertiHKPersonalService.verifyCertiHKPersonalExists(kycCertiHKPersonalReq.getCertificateNo());
        if(existsFlag){
            return ResultUtil.error(ResultEnum.MESSAGE_EXIST.getCode(), ResultEnum.MESSAGE_EXIST.getMsg());
        }
        log.info("保存香港个人-实名信息-开始");
        ResponseMessage addPersonResponseMessage = apiKycCertiHKPersonalService.certiHKPersonalAdd(kycCertiHKPersonalReq,kycNaturalVO);
        log.info("保存香港个人-实名信息-结束返回结果:{},描述信息:{}",addPersonResponseMessage.isSuccess(),addPersonResponseMessage.getMsg());
        if(!addPersonResponseMessage.isSuccess()){
            return addPersonResponseMessage;
        }
        log.info("香港人上传附件到寻汇-开始");
        String priId = addPersonResponseMessage.getData().toString();
        ResponseMessage uploadFileToXhResponseMessage = apiKycSunrateService.uploadFileToXH(priId);
        log.info("香港个人上传附件到寻汇-结束结束-返回结果:{},描述信息:{}",uploadFileToXhResponseMessage.isSuccess(),uploadFileToXhResponseMessage.getMsg());
        if(!uploadFileToXhResponseMessage.isSuccess()){
            return addPersonResponseMessage;
        }
        log.info("香港个人调用寻汇公共请求接口-开始");
        String uploadRemotePath = uploadFileToXhResponseMessage.getData().toString();
        KycSunrateRegisterReq kycSunrateRegisterReq = ConvertToKycSunrateRegisterReq(kycCertiHKPersonalReq, kycNaturalVO);
        kycSunrateRegisterReq.setDirPath(uploadRemotePath);
        ResponseMessage sendInfoToXhResponseMessage = apiSunrateRegisterService.sendRegisterInfoToXh(kycCertiHKPersonalReq.getBrowserIP(),priId,kycSunrateRegisterReq,kycNaturalVO);
        log.info("香港个人调用寻汇公共请求接口-结束-返回结果:{},描述信息:{}",sendInfoToXhResponseMessage.isSuccess(),sendInfoToXhResponseMessage.getMsg());

        log.info("香港个人调用寻汇添加受益人请求接口-开始");
        kycSunrateRegisterReq.setDirPath(uploadRemotePath);
        ResponseMessage beneficiaryResponse = jsKycSunrateBeneficiaryService.beneficiaryCreate(kycCertiHKPersonalReq.getCertificateNo(),kycCertiHKPersonalReq.getBrowserIP(),kycNaturalVO);
        log.info("香港个人调用寻汇添加受益人请求接口-结束-返回结果:{},描述信息:{}",beneficiaryResponse.isSuccess(),beneficiaryResponse.getMsg());
        return ResultUtil.success(ResultEnum.SUCCESS.getCode(), ResultEnum.SUCCESS.getMsg());
    }

    private KycSunrateRegisterReq ConvertToKycSunrateRegisterReq(KycCertiHKPersonalReq kycCertiHKPersonalReq, KycNaturalVO kycNaturalVO){
        KycSunrateRegisterReq kycSunrateRegisterReq = new KycSunrateRegisterReq();
        kycSunrateRegisterReq.setRegisterName(kycCertiHKPersonalReq.getCusName());
        kycSunrateRegisterReq.setRegisterEmail(kycNaturalVO.getEmail());
        kycSunrateRegisterReq.setRegisterMobile(kycNaturalVO.getPhoneNo());
        kycSunrateRegisterReq.setRegisterType(1);
        kycSunrateRegisterReq.setName(kycCertiHKPersonalReq.getCusName());
        kycSunrateRegisterReq.setOrgCode(kycCertiHKPersonalReq.getCertificateNo());
        kycSunrateRegisterReq.setIdentityType(1);// 1-法定代表人
        kycSunrateRegisterReq.setOpenAddress(kycCertiHKPersonalReq.getAddress());
        List<String> fileIdList = new ArrayList<>();
        for(KycCertiLinkFileReq kycCertiLinkFileReq : kycCertiHKPersonalReq.getKycCertiLinkFileReqList()){
            fileIdList.add(kycCertiLinkFileReq.getFileSaveName());
        }
        kycSunrateRegisterReq.setFileIdList(fileIdList);
        kycSunrateRegisterReq.setRemark("香港个人-注册");
        return kycSunrateRegisterReq;
    }
}
