package com.js.web.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.js.api.jspay.service.*;
import com.js.api.jspay.service.chinapnr.ChinaPNRPayOpenAccountService;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.*;
import com.js.common.model.req.*;
import com.js.common.model.vo.KycCertiLinkFileVO;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.web.service.JsKycBankService;
import com.js.web.service.JsKycNaturalService;
import com.js.web.service.JsKycSunrateBeneficiaryService;
import com.js.web.validate.code.ValidateCodeException;
import com.js.web.validate.code.ValidateCodeProcessorHolder;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * @Description: kyc_bank交互操作
 * @Author: liuh
 * @Create: 2019-06-22
 **/
@Slf4j
@Service
public class JsKycBankServiceImpl implements JsKycBankService {
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiKycBankService apiKycBankService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiSunrateTradePriceService apiSunrateTradePriceService;
    @Autowired
    private ValidateCodeProcessorHolder validateCodeProcessorHolder;
    @Autowired
    JsKycSunrateBeneficiaryService jsKycSunrateBeneficiaryService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ChinaPNRPayOpenAccountService chinaPNRPayOpenAccountService;

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiKycCertiLinkFileService apiKycCertiLinkFileService;
    @Autowired
    JsKycNaturalService jsKycNaturalService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiJsBankService apiJsBankService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiJsPayUserAcctService apiJsPayUserAcctService;

    @Override
    public ResponseMessage bankList(KycBankCardReq kycBankCardReq,KycNaturalVO kycNaturalVO) {
        kycBankCardReq.setKycNaturalId(kycNaturalVO.getId());
        return apiKycBankService.getKycBankList(kycBankCardReq);
    }

    @Override
    public ResponseMessage initAddBank(KycNaturalVO kycNaturalVO) {
        List<Map<String,Object>> bankAreaList = new ArrayList<>();//銀行所在地區集合
        Map<String,Object> bankArea;
        List<Map<String,Object>> currencyWbList = new ArrayList<>();//外幣集合
        Map<String,Object> currencyWbMap;
        List<Map<String,Object>> currencyCNYList = new ArrayList<>();//人民幣集合
        Map<String,Object> currencyCNYMap = new HashMap<>();
        List<Map<String,Object>> currencyAcctPersonalList = new ArrayList<>();//個人戶名集合
        Map<String, Object> acctPersonalNameMap;
        List<Map<String,Object>> currencyAcctCompanyList = new ArrayList<>();//企業戶名集合
        Map<String, Object> acctCompanyNameMap;
        List<Map<String,Object>> companyAcctTypeList = new ArrayList<>();//对公户时，对公，对私集合
        Map<String, Object> companyAcctTypeMap;
        //初始化对公户账户类型-开始
        for(BankAcctTypeEnum bankAcctTypeEnum : BankAcctTypeEnum.values()){
            companyAcctTypeMap = new HashMap<>();
            companyAcctTypeMap.put("companyAcctType", bankAcctTypeEnum.name());
            companyAcctTypeMap.put("companyAcctDesc", bankAcctTypeEnum.getDesc());
            companyAcctTypeList.add(companyAcctTypeMap);
        }
        //初始化对公户账户类型-结束

        //初始化银行所在地区-开始
        if( RegisterType.MAINLAND_PERSONAL.equals(kycNaturalVO.getRegisterType())
            || RegisterType.MAINLAND_COMPANY.equals(kycNaturalVO.getRegisterType())
            || RegisterType.HK_COMPANY.equals(kycNaturalVO.getRegisterType())){
            //银行所在地区-大陆
            bankArea = new HashMap<>();
            bankArea.put("bankAreaType",BankAreaType.MAIN_LAND.name());
            bankArea.put("bankAreaDesc", BankAreaType.MAIN_LAND.getDesc());
            bankAreaList.add(bankArea);
        }
        if( RegisterType.HK_PERSONAL.equals(kycNaturalVO.getRegisterType())
                || RegisterType.HK_COMPANY.equals(kycNaturalVO.getRegisterType())){
            //银行所在地区-香港
            bankArea = new HashMap<>();
            bankArea.put("bankAreaType",BankAreaType.HONG_KONG.name());
            bankArea.put("bankAreaDesc", BankAreaType.HONG_KONG.getDesc());
            bankAreaList.add(bankArea);
        }

        //初始化银行所在地区-结束

        //初始化币种-开始
        for(SiteEnum siteEnum : SiteEnum.values()){
            currencyWbMap = new HashMap<>();
            currencyWbMap.put("currencyKyc",siteEnum.getCurrency());
            currencyWbMap.put("currency",siteEnum.getCurrency() + "/" + siteEnum.getHyDesc());
            currencyWbList.add(currencyWbMap);
        }
        currencyCNYMap.put("currencyKyc",CommonConstant.TRADE_CURRENCY_CNY);
        currencyCNYMap.put("currency",CommonConstant.TRADE_CURRENCY_CNY + "/人民币");
        currencyCNYList.add(currencyCNYMap);
        //初始化币种-结束
        //初始化戶名-開始
        Object certiInfo = apiSunrateTradePriceService.findCertiInfo(kycNaturalVO.getId(), kycNaturalVO.getRegisterType());
        if(null == certiInfo){
            log.error("实名信息为空");
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(certiInfo));
        if( RegisterType.MAINLAND_PERSONAL.equals(kycNaturalVO.getRegisterType())){
            acctPersonalNameMap = new HashMap<>();
            acctPersonalNameMap.put("nameType",CommonConstant.TYPE_PERSONAL);
            acctPersonalNameMap.put("name",jsonObject.get("cusName"));
            currencyAcctPersonalList.add(acctPersonalNameMap);
        }else if(RegisterType.MAINLAND_COMPANY.equals(kycNaturalVO.getRegisterType())){
            acctPersonalNameMap = new HashMap<>();
            acctPersonalNameMap.put("nameType",CommonConstant.TYPE_PERSONAL);
            acctPersonalNameMap.put("name",jsonObject.get("legalRepresentativeName"));//法人名称
            currencyAcctPersonalList.add(acctPersonalNameMap);
            acctCompanyNameMap = new HashMap<>();
            acctCompanyNameMap.put("nameType",CommonConstant.TYPE_COMPANY);
            acctCompanyNameMap.put("name",jsonObject.get("companyName"));//公司名称
            currencyAcctCompanyList.add(acctCompanyNameMap);
        }else if( RegisterType.HK_PERSONAL.equals(kycNaturalVO.getRegisterType())){
            acctPersonalNameMap = new HashMap<>();
            acctPersonalNameMap.put("nameType",CommonConstant.TYPE_PERSONAL);
            acctPersonalNameMap.put("name",jsonObject.get("cusName"));
            currencyAcctPersonalList.add(acctPersonalNameMap);
        }else if(RegisterType.HK_COMPANY.equals(kycNaturalVO.getRegisterType())){
            acctPersonalNameMap = new HashMap<>();
            acctPersonalNameMap.put("nameType",CommonConstant.TYPE_PERSONAL);
            acctPersonalNameMap.put("name",jsonObject.get("directorName"));//董事名称
            currencyAcctPersonalList.add(acctPersonalNameMap);
            acctCompanyNameMap = new HashMap<>();
            acctCompanyNameMap.put("nameType",CommonConstant.TYPE_COMPANY);
            acctCompanyNameMap.put("name",jsonObject.get("companyName"));//公司名称
            currencyAcctCompanyList.add(acctCompanyNameMap);
        }
        //初始化戶名-結束
        JSONObject jsonObjectResult = new JSONObject();
        jsonObjectResult.put("bankArea",bankAreaList);//银行所在地区
        jsonObjectResult.put("currencyWb",currencyWbList);//外幣币种
        jsonObjectResult.put("currencyCNY",currencyCNYList);//人民幣币种
        jsonObjectResult.put("acctPersonalName",currencyAcctPersonalList);//個人账户名
        jsonObjectResult.put("acctCompanyName",currencyAcctCompanyList);//企業账户名
        jsonObjectResult.put("acctCompanyType",companyAcctTypeList);//企业账户类型


        KycNaturalVO kycNaturalVOResult = jsKycNaturalService.findKycNaturalVO(kycNaturalVO);
        boolean recordFlag = null == kycNaturalVOResult || null == kycNaturalVOResult.getRecordFlag() ? false : kycNaturalVOResult.getRecordFlag();
        jsonObjectResult.put("recordFlag",recordFlag);//是否通过经营者备案[1是，0否]
        return ResultUtil.success(jsonObjectResult);
    }

    @Override
    public ResponseMessage initCurrencyList(BankAreaType bankAra) {
        Set<String> currencySet = new HashSet<>();
        if(BankAreaType.MAIN_LAND.equals(bankAra)){
            currencySet.add(CommonConstant.TRADE_CURRENCY_CNY);
        }else{
            for(SiteEnum siteEnum : SiteEnum.values()){
                currencySet.add(siteEnum.getCurrency());
            }
        }
        return ResultUtil.success(currencySet);
    }

    @Override
    public ResponseMessage addBankCard(KycBankReq kycBankReq, KycNaturalVO kycNaturalVO, HttpServletResponse response) {
        Object certiInfo = apiSunrateTradePriceService.findCertiInfo(kycNaturalVO.getId(), kycNaturalVO.getRegisterType());
        JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(certiInfo));
        boolean sunrateFlag;
        //参数校验
        ResponseMessage validResult = paramsValid(kycBankReq,kycNaturalVO,jsonObject);
        if(!validResult.isSuccess()){
            return validResult;
        }
        sunrateFlag = Boolean.valueOf(validResult.getData().toString());
        //校验验证码是否正确
        try {
            ValidateCodeReq validateCodeReq = regiserReqConvertToValidateCodeReq(kycBankReq);
            validateCodeProcessorHolder.findValidateCodeProcessor("sms").validate(validateCodeReq, response);
        } catch (ValidateCodeException exception) {
            return ResultUtil.error(ResultEnum.VALIDATE_CODE_ERROT.getCode(),exception.getMessage());
        } catch (Exception e) {
            return ResultUtil.error(ResultEnum.VALIDATE_CODE_ERROT.getCode(),ResultEnum.VALIDATE_CODE_ERROT.getMsg());
        }
        kycBankReq.setRouteType(sunrateFlag ? SysPlateformType.SUNRATE : SysPlateformType.HFGJ);
        ResponseMessage responseMessageAdd = apiKycBankService.addBankCard(kycBankReq,kycNaturalVO);
        if(!responseMessageAdd.isSuccess()){
            return responseMessageAdd;
        }
        if(sunrateFlag){
            log.info("参数校验通过，绑卡提现渠道走寻汇，且受益人为源奉，已在提交实名信息时绑定，无需再次添加，提现时需要区别此类型需要主动打款操作");
//            KycSunrateBeneficiaryReq kycSunrateBeneficiaryReq = convertToKycSunrateBeneficiaryReq(kycBankReq,jsonObject,kycNaturalVO);
//            if(null == kycSunrateBeneficiaryReq){
//                log.error("组装寻汇添加受益人接口请求参数失败");
//                return responseMessageAdd;
//            }
//            log.info("调用寻汇添加受益人入参：{}",JSON.toJSONString(kycSunrateBeneficiaryReq));
//            ResponseMessage responseMessage = jsKycSunrateBeneficiaryService.beneficiaryCreate(kycSunrateBeneficiaryReq);
//            log.info("调用寻汇添加受益人结束-结果:{},{}",responseMessage.isSuccess(),responseMessage.getMsg());
        }else{
            boolean isFirstAdd = Boolean.valueOf(responseMessageAdd.getData().toString());
            log.info("isFirstAdd:{},bankArea:{}",isFirstAdd,kycBankReq.getStateOrRegion());
            //如果为首次参加且银行所在地区为大陆时请求汇付注册用户接口
            if(isFirstAdd && BankAreaType.MAIN_LAND.equals(kycBankReq.getStateOrRegion())){
                if(RegisterType.MAINLAND_PERSONAL.equals(kycNaturalVO.getRegisterType())
                    || (RegisterType.MAINLAND_COMPANY.equals(kycNaturalVO.getRegisterType()) && BankAcctTypeEnum.COMPANY_SELF.equals(kycBankReq.getCompanyAcctType()))
                    || (RegisterType.HK_COMPANY.equals(kycNaturalVO.getRegisterType()) && BankAcctTypeEnum.COMPANY_SELF.equals(kycBankReq.getCompanyAcctType()))){
                    //当实名类型为大陆个人时调用汇付开户接口开对私户
                    //当实名类型为大陆企业且账户类型选择对私时调用汇付开户接口开法人对私户
                    //当实名类型为香港企业且账户类型选择对私时调用汇付开户接口开董事对私户
                    ChinaPNRPersonalOpenAccountReq chinaPNRPersonalOpenAccountReq = convertToChinaPNRPersonalOpenAccountReq(kycNaturalVO,jsonObject,kycBankReq);
                    if(null == chinaPNRPersonalOpenAccountReq){
                        log.error("组装汇付开户对私接口请求参数失败");
                        return responseMessageAdd;
                    }
                    log.info("调用汇付对私开户入参：{}",JSON.toJSONString(chinaPNRPersonalOpenAccountReq));
                    ResponseMessage openResponse = chinaPNRPayOpenAccountService.personalOpenAccount(chinaPNRPersonalOpenAccountReq);
                    log.info("调用汇付对私开户结束-结果:{},{}",openResponse.isSuccess(),openResponse.getMsg());
                    if(openResponse.isSuccess()){
                        insertByChinaPNRPersonalOpenAccountReq(kycNaturalVO,BankAcctTypeEnum.COMPANY_SELF,chinaPNRPersonalOpenAccountReq);
                    }
                }else if(RegisterType.MAINLAND_COMPANY.equals(kycNaturalVO.getRegisterType()) && BankAcctTypeEnum.COMPANY_PUBLIC.equals(kycBankReq.getCompanyAcctType())){
                    //当注册类型为大陆企业或者香港企业时 调用汇付开户接口开对公户，如果选择法人则账户类型为对私，选择企业名称则账户类型为对公
                    ChinaPNREnterpriseOpenAccountReq chinaPNREnterpriseOpenAccountReq = convertToChinaPNREnterpriseOpenAccountReq(kycNaturalVO,jsonObject,kycBankReq);
                    if(null == chinaPNREnterpriseOpenAccountReq){
                        log.error("组装汇付开户对公接口请求参数失败");
                        return responseMessageAdd;
                    }
                    log.info("调用汇付对公开户入参：{}",JSON.toJSONString(chinaPNREnterpriseOpenAccountReq));
                    ResponseMessage openResponse = chinaPNRPayOpenAccountService.enterpriseOpenAccount(chinaPNREnterpriseOpenAccountReq);
                    log.info("调用汇付对公开户结束-结果:{},{}",openResponse.isSuccess(),openResponse.getMsg());
                    if(openResponse.isSuccess()){
                        insertByChinaPNREnterpriseOpenAccountReq(kycNaturalVO,BankAcctTypeEnum.COMPANY_PUBLIC,chinaPNREnterpriseOpenAccountReq);
                    }
                }else{
                   log.error("注册类型不正确:{}",kycBankReq.getStateOrRegion());
                }
            }
        }
        return responseMessageAdd;
    }

    private void insertByChinaPNRPersonalOpenAccountReq(KycNaturalVO kycNaturalVO,BankAcctTypeEnum acctType,ChinaPNRPersonalOpenAccountReq chinaPNRPersonalOpenAccountReq){
        JsPayUserAcctReq jsPayUserAcctReq = new JsPayUserAcctReq();
        jsPayUserAcctReq.setPlateformType(SysPlateformType.HFGJ);
        jsPayUserAcctReq.setKycNaturalId(kycNaturalVO.getId());
        jsPayUserAcctReq.setAcctType(acctType);
        jsPayUserAcctReq.setAcctName(chinaPNRPersonalOpenAccountReq.getAcctName());
        jsPayUserAcctReq.setAcctNo(chinaPNRPersonalOpenAccountReq.getJsOpenAccountNo());//用户号
        ResponseMessage responseMessage = apiJsPayUserAcctService.addJsPayUserAcct(jsPayUserAcctReq, kycNaturalVO);
        log.info("保存客户第三方账户结果：{}",JSON.toJSONString(responseMessage));
    }

    private void insertByChinaPNREnterpriseOpenAccountReq(KycNaturalVO kycNaturalVO,BankAcctTypeEnum acctType,ChinaPNREnterpriseOpenAccountReq chinaPNREnterpriseOpenAccountReq){
        JsPayUserAcctReq jsPayUserAcctReq = new JsPayUserAcctReq();
        jsPayUserAcctReq.setPlateformType(SysPlateformType.HFGJ);
        jsPayUserAcctReq.setKycNaturalId(kycNaturalVO.getId());
        jsPayUserAcctReq.setAcctType(acctType);
        jsPayUserAcctReq.setAcctName(chinaPNREnterpriseOpenAccountReq.getAcctName());//账户名称
        jsPayUserAcctReq.setAcctNo(chinaPNREnterpriseOpenAccountReq.getJsOpenAccountNo());//用户号
        ResponseMessage responseMessage = apiJsPayUserAcctService.addJsPayUserAcct(jsPayUserAcctReq, kycNaturalVO);
        log.info("保存客户第三方账户结果：{}",JSON.toJSONString(responseMessage));
    }

    private ResponseMessage paramsValid(KycBankReq kycBankReq,KycNaturalVO kycNaturalVO,JSONObject jsonObject){
        //币种校验
        if(!CommonConstant.TRADE_CURRENCY_CNY.equals(kycBankReq.getCurrencyCode()) && null == SiteEnum.getByCurrency(kycBankReq.getCurrencyCode())){
            return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-币种不正确");
        }
        //是否调用寻汇标识，true走寻汇添加受益人，false表示走汇付开户
        boolean sunrateFlag = false;
        //注册类型为香港个人时，校验swiftcode，并赋值sunrateFlag走寻汇通道
        if(RegisterType.HK_PERSONAL.equals(kycNaturalVO.getRegisterType())){
            if(StringUtils.isBlank(kycBankReq.getSwiftCode())){
                return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-swiftcode不能为空");
            }
            sunrateFlag = true;
        }
        //注册类型为大陆个人时，校验bankCode
        if(RegisterType.MAINLAND_PERSONAL.equals(kycNaturalVO.getRegisterType())){
            if(StringUtils.isBlank(kycBankReq.getBankCode())){
                return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-银行Code不能为空");
            }
        }
        //当注册类型为大陆企业时
        if(RegisterType.MAINLAND_COMPANY.equals(kycNaturalVO.getRegisterType())){
            if(StringUtils.isBlank(kycBankReq.getBankCode())){
                return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-银行Code不能为空");
            }
            BankAcctTypeEnum companyAcctType = kycBankReq.getCompanyAcctType();
            //账户类型为必选择项，为空返回错误信息
            if(null == companyAcctType){
                return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-大陆企业请选择开户账户类型");
            }
            //当账户类型为对私时，校验外币情况
            if(BankAcctTypeEnum.COMPANY_SELF.equals(companyAcctType)){
                String currencyCode = kycBankReq.getCurrencyCode();
                if(!CommonConstant.TRADE_CURRENCY_CNY.equals(currencyCode)){
                    return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-大陆企业账户类型对私时币种不能选择外币");
                }
            }
            //当账户类型选择对公时
            if(BankAcctTypeEnum.COMPANY_PUBLIC.equals(companyAcctType)){
                String currencyCode = kycBankReq.getCurrencyCode();
                //当对公类型选择人民币种时
                if(CommonConstant.TRADE_CURRENCY_CNY.equals(currencyCode)){
                    String provinceCode = kycBankReq.getProvinceCode();
                    if(StringUtils.isBlank(provinceCode)){
                        return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-大陆企业账户类型对公时省份编码不能为空");
                    }
                    String provinceName = kycBankReq.getProvinceName();
                    if(StringUtils.isBlank(provinceName)){
                        return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-大陆企业账户类型对公时省份名称不能为空");
                    }
                    String cityCode = kycBankReq.getCityCode();
                    if(StringUtils.isBlank(cityCode)){
                        return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-大陆企业账户类型对公时城市编码不能为空");
                    }
                    String cityName = kycBankReq.getCityName();
                    if(StringUtils.isBlank(cityName)){
                        return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-大陆企业账户类型对公时城市名称不能为空");
                    }
//                    String bankBranchCode = kycBankReq.getBankBranchCode();
//                    if(StringUtils.isBlank(bankBranchCode)){
//                        return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-大陆企业账户类型对公时支行编码不能为空");
//                    }
                    String bankBranchName = kycBankReq.getBankBranchName();
                    if(StringUtils.isBlank(bankBranchName)){
                        return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-大陆企业账户类型对公时支行名称不能为空");
                    }
                }else{
                    KycNaturalVO kycNaturalVOResult = jsKycNaturalService.findKycNaturalVO(kycNaturalVO);
                    boolean recordFlag = null == kycNaturalVOResult || null == kycNaturalVOResult.getRecordFlag() ? false : kycNaturalVOResult.getRecordFlag();
                    if(!recordFlag){
                        return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-大陆企业账户类型对公时因备案未通过不可以选择外币");
                    }
                    //当对公类型选择外币币种时
                    sunrateFlag = true;
                    if(StringUtils.isBlank(kycBankReq.getSwiftCode())){
                        return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-swiftcode不能为空");
                    }
                }
            }
        }
        //当注册类型为香港企业时
        if(RegisterType.HK_COMPANY.equals(kycNaturalVO.getRegisterType())){
            BankAcctTypeEnum companyAcctType = kycBankReq.getCompanyAcctType();
            //账户类型为必选择项，为空返回错误信息
            if(null == companyAcctType){
                return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-香港企业请选择开户账户类型");
            }
            //当账户类型为对私时，校验外币情况
            if(BankAcctTypeEnum.COMPANY_SELF.equals(companyAcctType)){
                if(StringUtils.isBlank(kycBankReq.getBankCode())){
                    return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-银行Code不能为空");
                }
                //对私时校验董事证件类型，只能为二代身份证件类型
                String directorIdType = null == jsonObject.get("directorIdType") ? "" : jsonObject.getString("directorIdType");
                if(!CertiFileType.ID_CARD.name().equals(directorIdType)){
                    return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-香港企业董事证件类型不正确");
                }
                String currencyCode = kycBankReq.getCurrencyCode();
                //当选择对私类型且选择币种不为人民币时提示错误信息
                if(!CommonConstant.TRADE_CURRENCY_CNY.equals(currencyCode)){
                    return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-香港企业账户类型对私时币种不能选择外币");
                }
            }
            //当账户类型选择对公时
            if(BankAcctTypeEnum.COMPANY_PUBLIC.equals(companyAcctType)){
                String currencyCode = kycBankReq.getCurrencyCode();
                //当对公类型选择人民币种时
                if(CommonConstant.TRADE_CURRENCY_CNY.equals(currencyCode)){
                    return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-香港企业账户类型对公时币种不能选择人民币");
                }else{
                    //当对公类型选择外币币种时
                    sunrateFlag = true;
                    if(StringUtils.isBlank(kycBankReq.getSwiftCode())){
                        return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-swiftcode不能为空");
                    }
                }
            }
        }
        return ResultUtil.success(sunrateFlag);
    }

    private ValidateCodeReq regiserReqConvertToValidateCodeReq(KycBankReq kycBankReq){
        ValidateCodeReq validateCodeReq = new ValidateCodeReq();
        validateCodeReq.setMarkStr(kycBankReq.getMarkStr());
        validateCodeReq.setPhoneNo(kycBankReq.getPhone());
        validateCodeReq.setSmsCode(kycBankReq.getSmsCode());
        return validateCodeReq;
    }

    //封装请求汇付注册对公用户接口请求参数
    private ChinaPNREnterpriseOpenAccountReq convertToChinaPNREnterpriseOpenAccountReq(KycNaturalVO kycNaturalVO,JSONObject jsonObject,KycBankReq kycBankReq){
        ChinaPNREnterpriseOpenAccountReq chinaPNREnterpriseOpenAccountReq = new ChinaPNREnterpriseOpenAccountReq();
        chinaPNREnterpriseOpenAccountReq.setKycNaturalId(kycNaturalVO.getId());
        chinaPNREnterpriseOpenAccountReq.setRequestId(IdUtil.simpleUUID());//请求流水号
        chinaPNREnterpriseOpenAccountReq.setPlatformRegTime(DateUtil.format(new Date(),"yyyy-MM-dd HH:mm:ss"));//用户注册时间
        chinaPNREnterpriseOpenAccountReq.setName(kycBankReq.getAccountName());
        chinaPNREnterpriseOpenAccountReq.setJsOpenAccountNo(IdUtil.simpleUUID());
        String companyNatureId = jsonObject.getString("companyNatureId");
        //企业类型  1-个体工商户 2-企业
        chinaPNREnterpriseOpenAccountReq.setType(CompanyNatureEnum.COMPANY_NATURE_02.getCode().equals(companyNatureId) ? "1" : "2");
        chinaPNREnterpriseOpenAccountReq.setPhone(kycNaturalVO.getPhoneNo());
        chinaPNREnterpriseOpenAccountReq.setOrgCode(jsonObject.getString("unifiedSocialCreditCode"));//组织机构代码
//        chinaPNREnterpriseOpenAccountReq.setOrgExpDateEnd("");//织机构代码失效日期
        chinaPNREnterpriseOpenAccountReq.setBizLicenseCode(jsonObject.getString("unifiedSocialCreditCode"));//营业执照号-统一社会信用代码
//        chinaPNREnterpriseOpenAccountReq.setBizLicenseExpDateEnd("");//营业执照失效日期
        chinaPNREnterpriseOpenAccountReq.setTaxRegCode(jsonObject.getString("unifiedSocialCreditCode"));//税务登记号
//        chinaPNREnterpriseOpenAccountReq.setTaxRegExpDateEnd("");//税务登记证失效日期
        chinaPNREnterpriseOpenAccountReq.setBankCode(kycBankReq.getBankCode());//开户银行
        chinaPNREnterpriseOpenAccountReq.setBankAcct(kycBankReq.getAccountNo());//账号
        chinaPNREnterpriseOpenAccountReq.setAcctName(kycBankReq.getAccountName());//户名
        chinaPNREnterpriseOpenAccountReq.setAcctType("1");//账户类型-对公
        chinaPNREnterpriseOpenAccountReq.setProvince(kycBankReq.getProvinceCode());//省份编码
//        chinaPNREnterpriseOpenAccountReq.setArea("");//地区编码
        chinaPNREnterpriseOpenAccountReq.setBankBranch(kycBankReq.getBankBranchName());//支行名称
//        chinaPNREnterpriseOpenAccountReq.setUniteBankCode("");//收款行联行号

        /**
         * 开户许可证影印件
         */
//        private String openLicensePhotoCopy;

        //当注册类型为大陆企业且账户类型选择对公时，调用汇付开对公户
        if(RegisterType.MAINLAND_COMPANY.equals(kycNaturalVO.getRegisterType()) && BankAcctTypeEnum.COMPANY_PUBLIC.equals(kycBankReq.getCompanyAcctType())){
            chinaPNREnterpriseOpenAccountReq.setLegalPerson(jsonObject.getString("legalRepresentativeName"));//法人名称
            chinaPNREnterpriseOpenAccountReq.setLegalCertType(jsonObject.getString("legalRepresentativeIdNo"));//法人证件号
            chinaPNREnterpriseOpenAccountReq.setAddress(jsonObject.getString("legalRepresentativeAddress"));//企业地址
            // TODO 缺少身份证正反面解析
        }else{
            log.info("注册类型不符合:{}",kycNaturalVO.getRegisterType());
            return null;
        }
        List<KycCertiLinkFileVO> certiFileList = apiKycCertiLinkFileService.findCertiFileList(jsonObject.getString("id"));
        certiFileList.stream().forEach(kycCertiLinkFileVO -> {
            if(CertiFileType.CARD_FRONT_IMAGE.equals(kycCertiLinkFileVO.getFileType())){
                chinaPNREnterpriseOpenAccountReq.setLegalCertPhotoCopyF(kycCertiLinkFileVO.getFileSavePath());//法人身份证正面影像
            }else if(CertiFileType.CARD_BACK_IMAGE.equals(kycCertiLinkFileVO.getFileType())){
                chinaPNREnterpriseOpenAccountReq.setLegalCertPhotoCopyB(kycCertiLinkFileVO.getFileSavePath());//法人身份证反面影像
            }else if(CertiFileType.BUSINESS_LICENSE_IMAGE.equals(kycCertiLinkFileVO.getFileType())){
                chinaPNREnterpriseOpenAccountReq.setBizLicensePhotoCopy(kycCertiLinkFileVO.getFileSavePath());//营业执照影印件
                chinaPNREnterpriseOpenAccountReq.setOrgPhotoCopy(kycCertiLinkFileVO.getFileSavePath());//组织机构代码证影印件
                chinaPNREnterpriseOpenAccountReq.setTaxRegPhotoCopy(kycCertiLinkFileVO.getFileSavePath());//税务登记证影印件
            }
        });
        return chinaPNREnterpriseOpenAccountReq;
    }

    //封装请求汇付注册对私用户接口请求参数
    private ChinaPNRPersonalOpenAccountReq convertToChinaPNRPersonalOpenAccountReq(KycNaturalVO kycNaturalVO,JSONObject jsonObject,KycBankReq kycBankReq){
        ChinaPNRPersonalOpenAccountReq chinaPNRPersonalOpenAccountReq = new ChinaPNRPersonalOpenAccountReq();
        chinaPNRPersonalOpenAccountReq.setKycNaturalId(kycNaturalVO.getId());
        chinaPNRPersonalOpenAccountReq.setRequestId(IdUtil.simpleUUID());//请求流水号
        chinaPNRPersonalOpenAccountReq.setPlatformRegTime(DateUtil.format(new Date(),"yyyy-MM-dd HH:mm:ss"));//用户注册时间
        chinaPNRPersonalOpenAccountReq.setCertType("00");//00－身份证（目前仅支持00）
        chinaPNRPersonalOpenAccountReq.setCertExpDateEnd(jsonObject.getString("effectiveEndTime"));//证件失效日期
        chinaPNRPersonalOpenAccountReq.setMobileNumber(kycBankReq.getPhone());//手机号
        chinaPNRPersonalOpenAccountReq.setEmail(kycNaturalVO.getEmail());
        chinaPNRPersonalOpenAccountReq.setBankCode(kycBankReq.getBankCode());
        chinaPNRPersonalOpenAccountReq.setBankAcct(kycBankReq.getAccountNo());//账号
        chinaPNRPersonalOpenAccountReq.setAcctName(kycBankReq.getAccountName());//户名
        chinaPNRPersonalOpenAccountReq.setJsOpenAccountNo(IdUtil.simpleUUID());
        if(RegisterType.MAINLAND_PERSONAL.equals(kycNaturalVO.getRegisterType())){
            chinaPNRPersonalOpenAccountReq.setName(jsonObject.getString("cusName"));//客户姓名
            chinaPNRPersonalOpenAccountReq.setCertId(jsonObject.getString("idNo"));//个人证件号
            chinaPNRPersonalOpenAccountReq.setAddress(jsonObject.getString("liveAddress"));
        }else if(RegisterType.MAINLAND_COMPANY.equals(kycNaturalVO.getRegisterType()) && BankAcctTypeEnum.COMPANY_SELF.equals(kycBankReq.getCompanyAcctType())){
            chinaPNRPersonalOpenAccountReq.setName(jsonObject.getString("legalRepresentativeName"));//法定代表人姓名
            chinaPNRPersonalOpenAccountReq.setCertId(jsonObject.getString("legalRepresentativeIdNo"));//法定代表人证件号
            chinaPNRPersonalOpenAccountReq.setAddress(jsonObject.getString("legalRepresentativeAddress"));//法定代表人住址
        }else if(RegisterType.HK_COMPANY.equals(kycNaturalVO.getRegisterType()) && BankAcctTypeEnum.COMPANY_SELF.equals(kycBankReq.getCompanyAcctType())){
            chinaPNRPersonalOpenAccountReq.setName(jsonObject.getString("directorName"));//董事姓名
            chinaPNRPersonalOpenAccountReq.setCertId(jsonObject.getString("directorIdNo"));//董事证件号
            chinaPNRPersonalOpenAccountReq.setAddress(jsonObject.getString("directorAddress"));//董事住址
        }else{
            log.info("注册类型不符合:{}",kycNaturalVO.getRegisterType());
            return null;
        }
        List<KycCertiLinkFileVO> certiFileList = apiKycCertiLinkFileService.findCertiFileList(jsonObject.getString("id"));
        certiFileList.stream().forEach(kycCertiLinkFileVO -> {
            if(CertiFileType.CARD_FRONT_IMAGE.equals(kycCertiLinkFileVO.getFileType())){
                chinaPNRPersonalOpenAccountReq.setCertPhotoCopyF(kycCertiLinkFileVO.getFileSavePath());//身份证正面影像
            }else if(CertiFileType.CARD_BACK_IMAGE.equals(kycCertiLinkFileVO.getFileType())){
                chinaPNRPersonalOpenAccountReq.setCertPhotoCopyB(kycCertiLinkFileVO.getFileSavePath());//身份证反面影像
            }
        });
        return chinaPNRPersonalOpenAccountReq;
    }

    //封装请求寻汇添加受益人接口请求参数
    private KycSunrateBeneficiaryReq convertToKycSunrateBeneficiaryReq(KycBankReq kycBankReq,JSONObject jsonObject,KycNaturalVO kycNaturalVO){
        KycSunrateBeneficiaryReq kycSunrateBeneficiaryReq = new KycSunrateBeneficiaryReq();
        kycSunrateBeneficiaryReq.setCountryCode("HK");//国家代码
        kycSunrateBeneficiaryReq.setBankName(kycBankReq.getBankName());
        kycSunrateBeneficiaryReq.setRouteType("3");
        kycSunrateBeneficiaryReq.setSwiftcode(kycBankReq.getSwiftCode());
        kycSunrateBeneficiaryReq.setBeneficiaryName(kycBankReq.getAccountName());//受益人名称
        kycSunrateBeneficiaryReq.setBeneficiaryAcctNo(kycBankReq.getAccountNo());//受益人账号
        kycSunrateBeneficiaryReq.setCur(kycBankReq.getCurrencyCode());
        kycSunrateBeneficiaryReq.setRemark("添加受益人bank");
        if( RegisterType.HK_PERSONAL.equals(kycNaturalVO.getRegisterType())){
            kycSunrateBeneficiaryReq.setOrgCode(jsonObject.getString("certificateNo"));//orgCode取值-证件号
            kycSunrateBeneficiaryReq.setBeneficiaryAddr(jsonObject.getString("address"));//受益人地址取香港个人地址
        }else if(RegisterType.HK_COMPANY.equals(kycNaturalVO.getRegisterType())){
            kycSunrateBeneficiaryReq.setOrgCode(jsonObject.getString("companyRegisteredCertificateNo"));//orgCode取值-公司注册证书编号
            kycSunrateBeneficiaryReq.setBeneficiaryAddr(jsonObject.getString("companyAddress"));//受益人地址取香港企业公司经营地址
        }else{
            log.info("注册类型不符合:{}",kycNaturalVO.getRegisterType());
            return null;
        }
        return kycSunrateBeneficiaryReq;
    }

    @Override
    public ResponseMessage getProvence() {
        return apiKycBankService.getProvence();
    }

    @Override
    public ResponseMessage getCity(String provinceCode) {
        return apiKycBankService.getCity(provinceCode);
    }

    @Override
    public ResponseMessage disableBankCard(KycBankDeleteReq kycBankDeleteReq, KycNaturalVO kycNaturalVO,HttpServletResponse response) {
        //校验验证码是否正确
        try {
            KycBankReq kycBankReq = new KycBankReq();
            kycBankReq.setMarkStr(kycBankDeleteReq.getMarkStr());
            kycBankReq.setPhone(kycBankDeleteReq.getPhone());
            kycBankReq.setSmsCode(kycBankDeleteReq.getSmsCode());
            ValidateCodeReq validateCodeReq = regiserReqConvertToValidateCodeReq(kycBankReq);
            validateCodeProcessorHolder.findValidateCodeProcessor("sms").validate(validateCodeReq, response);
        } catch (ValidateCodeException exception) {
            return ResultUtil.error(ResultEnum.VALIDATE_CODE_ERROT.getCode(),exception.getMessage());
        } catch (Exception e) {
            return ResultUtil.error(ResultEnum.VALIDATE_CODE_ERROT.getCode(),ResultEnum.VALIDATE_CODE_ERROT.getMsg());
        }
        return apiKycBankService.disableBankCard(kycBankDeleteReq.getBankId(),kycNaturalVO);
    }

    @Override
    public ResponseMessage checkBank(KycCheckBankReq kycCheckBankReq) {
        return apiKycBankService.checkBank(kycCheckBankReq);
    }

    @Override
    public ResponseMessage findJsBankList() {
        return apiJsBankService.findJsBankList();
    }
}
