package com.js.web.service.impl;

import com.js.api.jspay.service.chinapnr.ChinaPNRPayOpenAccountService;
import com.js.api.jspay.service.chinapnr.ChinaPNRPaySubstituteService;
import com.js.common.constant.Constant;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.ChinapnrCallbackSerivce;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @Description: 汇付国际回调
 * @Author: zhouyongsheng
 * @Create: 2019-06-18
 **/
@Slf4j
@Service
public class ChinapnrCallbackSerivceImpl implements ChinapnrCallbackSerivce {

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ChinaPNRPaySubstituteService chinaPNRPaySubstituteService;

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ChinaPNRPayOpenAccountService chinaPNRPayOpenAccountService;


    /**
     * 汇付国际提现回调
     * @param map
     * @return
     * @throws Exception
     */
    @Override
    public ResponseMessage substituteNewCallback(Map<String, String> map) {
        ResponseMessage responseMessage = chinaPNRPaySubstituteService.newCallbackSubstitute(map);
        return responseMessage;
    }

    /**
     * 汇付国际还款汇差等回调
     * @param resXml
     * @return
     * @throws Exception
     */
    @Override
    public ResponseMessage substituteOldCallback(String resXml) {
        ResponseMessage responseMessage = chinaPNRPaySubstituteService.oldCallbackSubstitute(resXml);
        return responseMessage;
    }

    /**
     * 汇付国际个人开户回调
     * @param map
     * @return
     * @throws Exception
     */
    @Override
    public ResponseMessage opendAccountPersonal(Map<String, String> map) {
        ResponseMessage responseMessage = chinaPNRPayOpenAccountService.personalCallbackOpenAccount(map);
        return responseMessage;
    }

    /**
     * 汇付国际企业开户回调
     * @param map
     * @return
     * @throws Exception
     */
    @Override
    public ResponseMessage opendAccountEnterprise(Map<String, String> map) {
        ResponseMessage responseMessage = chinaPNRPayOpenAccountService.enterpriseCallbackOpenAccount(map);
        return responseMessage;
    }
}
