package com.js.web.service;

import com.js.common.enums.RegisterType;
import com.js.common.enums.TradeSubTypeEnum;
import com.js.common.model.req.JsPayVatPaymentInfoReq;
import com.js.common.model.req.JsPayVatPaymentRcvListReq;
import com.js.common.model.req.JsTradeListReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
        * @Description: VAT 缴税 服务接口
        * @Author: liwm
        * @Create: 2019-06-27
        **/
public interface JsPayVatPaymentInfoService {
    /**
     * @Description: 缴税收款人列表
     * @Author liwm
     * @Date 2019/6/27
     **/
    ResponseMessage queryRcvList(JsPayVatPaymentRcvListReq jsPayVatPaymentRcvListReq);

    /**
     * @Description: vat 缴税 提交
     * @Author liwm
     * @Date 2019/6/28
     **/
    ResponseMessage payVatPayment(JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq, RegisterType registerType);
}
